/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.css.model;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.css.model.MediaQuery;
import org.openqa.selenium.devtools.css.model.SourceRange;
import org.openqa.selenium.devtools.css.model.StyleSheetId;
import org.openqa.selenium.json.JsonInput;

public class CSSMedia {
    private final String text;
    private final Source source;
    private final String sourceURL;
    private final SourceRange range;
    private final StyleSheetId styleSheetId;
    private final List<MediaQuery> mediaList;

    public CSSMedia(String text, Source source, String sourceURL, SourceRange range, StyleSheetId styleSheetId, List<MediaQuery> mediaList) {
        this.text = Objects.requireNonNull(text, "text is required");
        this.source = Objects.requireNonNull(source, "source is required");
        this.sourceURL = sourceURL;
        this.range = range;
        this.styleSheetId = styleSheetId;
        this.mediaList = mediaList;
    }

    public String getText() {
        return this.text;
    }

    public Source getSource() {
        return this.source;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public SourceRange getRange() {
        return this.range;
    }

    public StyleSheetId getStyleSheetId() {
        return this.styleSheetId;
    }

    public List<MediaQuery> getMediaList() {
        return this.mediaList;
    }

    private static CSSMedia fromJson(JsonInput input) {
        String text = null;
        Source source = null;
        String sourceURL = null;
        SourceRange range = null;
        StyleSheetId styleSheetId = null;
        List mediaList = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "text": {
                    text = input.nextString();
                    continue block16;
                }
                case "source": {
                    source = Source.fromString(input.nextString());
                    continue block16;
                }
                case "sourceURL": {
                    sourceURL = input.nextString();
                    continue block16;
                }
                case "range": {
                    range = (SourceRange)input.read(SourceRange.class);
                    continue block16;
                }
                case "styleSheetId": {
                    styleSheetId = (StyleSheetId)input.read(StyleSheetId.class);
                    continue block16;
                }
                case "mediaList": {
                    mediaList = (List)input.read(new TypeToken<List<MediaQuery>>(){}.getType());
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSMedia(text, source, sourceURL, range, styleSheetId, mediaList);
    }

    public static enum Source {
        MEDIARULE("mediaRule"),
        IMPORTRULE("importRule"),
        LINKEDSHEET("linkedSheet"),
        INLINESHEET("inlineSheet");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public static Source fromString(String s) {
            return Arrays.stream(Source.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Source "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Source fromJson(JsonInput input) {
            return Source.fromString(input.nextString());
        }
    }
}

