/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.animation.model;

import java.util.Objects;
import org.openqa.selenium.devtools.animation.model.KeyframesRule;
import org.openqa.selenium.devtools.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class AnimationEffect {
    private final Number delay;
    private final Number endDelay;
    private final Number iterationStart;
    private final Number iterations;
    private final Number duration;
    private final String direction;
    private final String fill;
    private final BackendNodeId backendNodeId;
    private final KeyframesRule keyframesRule;
    private final String easing;

    public AnimationEffect(Number delay, Number endDelay, Number iterationStart, Number iterations, Number duration, String direction, String fill, BackendNodeId backendNodeId, KeyframesRule keyframesRule, String easing) {
        this.delay = Objects.requireNonNull(delay, "delay is required");
        this.endDelay = Objects.requireNonNull(endDelay, "endDelay is required");
        this.iterationStart = Objects.requireNonNull(iterationStart, "iterationStart is required");
        this.iterations = Objects.requireNonNull(iterations, "iterations is required");
        this.duration = Objects.requireNonNull(duration, "duration is required");
        this.direction = Objects.requireNonNull(direction, "direction is required");
        this.fill = Objects.requireNonNull(fill, "fill is required");
        this.backendNodeId = backendNodeId;
        this.keyframesRule = keyframesRule;
        this.easing = Objects.requireNonNull(easing, "easing is required");
    }

    public Number getDelay() {
        return this.delay;
    }

    public Number getEndDelay() {
        return this.endDelay;
    }

    public Number getIterationStart() {
        return this.iterationStart;
    }

    public Number getIterations() {
        return this.iterations;
    }

    public Number getDuration() {
        return this.duration;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getFill() {
        return this.fill;
    }

    public BackendNodeId getBackendNodeId() {
        return this.backendNodeId;
    }

    public KeyframesRule getKeyframesRule() {
        return this.keyframesRule;
    }

    public String getEasing() {
        return this.easing;
    }

    private static AnimationEffect fromJson(JsonInput input) {
        Number delay = null;
        Number endDelay = null;
        Number iterationStart = null;
        Number iterations = null;
        Number duration = null;
        String direction = null;
        String fill = null;
        BackendNodeId backendNodeId = null;
        KeyframesRule keyframesRule = null;
        String easing = null;
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "delay": {
                    delay = input.nextNumber();
                    continue block24;
                }
                case "endDelay": {
                    endDelay = input.nextNumber();
                    continue block24;
                }
                case "iterationStart": {
                    iterationStart = input.nextNumber();
                    continue block24;
                }
                case "iterations": {
                    iterations = input.nextNumber();
                    continue block24;
                }
                case "duration": {
                    duration = input.nextNumber();
                    continue block24;
                }
                case "direction": {
                    direction = input.nextString();
                    continue block24;
                }
                case "fill": {
                    fill = input.nextString();
                    continue block24;
                }
                case "backendNodeId": {
                    backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                    continue block24;
                }
                case "keyframesRule": {
                    keyframesRule = (KeyframesRule)input.read(KeyframesRule.class);
                    continue block24;
                }
                case "easing": {
                    easing = input.nextString();
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AnimationEffect(delay, endDelay, iterationStart, iterations, duration, direction, fill, backendNodeId, keyframesRule, easing);
    }
}

