/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.accessibility.model;

import java.util.Objects;
import org.openqa.selenium.devtools.accessibility.model.AXValue;
import org.openqa.selenium.devtools.accessibility.model.AXValueNativeSourceType;
import org.openqa.selenium.devtools.accessibility.model.AXValueSourceType;
import org.openqa.selenium.json.JsonInput;

public class AXValueSource {
    private final AXValueSourceType type;
    private final AXValue value;
    private final String attribute;
    private final AXValue attributeValue;
    private final Boolean superseded;
    private final AXValueNativeSourceType nativeSource;
    private final AXValue nativeSourceValue;
    private final Boolean invalid;
    private final String invalidReason;

    public AXValueSource(AXValueSourceType type, AXValue value, String attribute, AXValue attributeValue, Boolean superseded, AXValueNativeSourceType nativeSource, AXValue nativeSourceValue, Boolean invalid, String invalidReason) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.value = value;
        this.attribute = attribute;
        this.attributeValue = attributeValue;
        this.superseded = superseded;
        this.nativeSource = nativeSource;
        this.nativeSourceValue = nativeSourceValue;
        this.invalid = invalid;
        this.invalidReason = invalidReason;
    }

    public AXValueSourceType getType() {
        return this.type;
    }

    public AXValue getValue() {
        return this.value;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public AXValue getAttributeValue() {
        return this.attributeValue;
    }

    public Boolean getSuperseded() {
        return this.superseded;
    }

    public AXValueNativeSourceType getNativeSource() {
        return this.nativeSource;
    }

    public AXValue getNativeSourceValue() {
        return this.nativeSourceValue;
    }

    public Boolean getInvalid() {
        return this.invalid;
    }

    public String getInvalidReason() {
        return this.invalidReason;
    }

    private static AXValueSource fromJson(JsonInput input) {
        AXValueSourceType type = null;
        AXValue value = null;
        String attribute = null;
        AXValue attributeValue = null;
        Boolean superseded = null;
        AXValueNativeSourceType nativeSource = null;
        AXValue nativeSourceValue = null;
        Boolean invalid = null;
        String invalidReason = null;
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = (AXValueSourceType)((Object)input.read(AXValueSourceType.class));
                    continue block22;
                }
                case "value": {
                    value = (AXValue)input.read(AXValue.class);
                    continue block22;
                }
                case "attribute": {
                    attribute = input.nextString();
                    continue block22;
                }
                case "attributeValue": {
                    attributeValue = (AXValue)input.read(AXValue.class);
                    continue block22;
                }
                case "superseded": {
                    superseded = input.nextBoolean();
                    continue block22;
                }
                case "nativeSource": {
                    nativeSource = (AXValueNativeSourceType)((Object)input.read(AXValueNativeSourceType.class));
                    continue block22;
                }
                case "nativeSourceValue": {
                    nativeSourceValue = (AXValue)input.read(AXValue.class);
                    continue block22;
                }
                case "invalid": {
                    invalid = input.nextBoolean();
                    continue block22;
                }
                case "invalidReason": {
                    invalidReason = input.nextString();
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AXValueSource(type, value, attribute, attributeValue, superseded, nativeSource, nativeSourceValue, invalid, invalidReason);
    }
}

