/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.target.model;

import java.util.Objects;
import org.openqa.selenium.devtools.target.model.TargetInfo;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.remote.SessionId;

public class AttachToTarget {
    private final SessionId sessionId;
    private final TargetInfo targetInfo;
    private final boolean waitForDebugger;

    public AttachToTarget(SessionId sessionId, TargetInfo targetInfo, Boolean waitForDebugger) {
        this.sessionId = Objects.requireNonNull(sessionId, "sessionId is required");
        this.targetInfo = Objects.requireNonNull(targetInfo, "targetInfo is required");
        this.waitForDebugger = Objects.requireNonNull(waitForDebugger, "waitForDebugger is require");
    }

    private static AttachToTarget fromJson(JsonInput input) {
        SessionId sessionId = (SessionId)input.read(SessionId.class);
        TargetInfo targetInfo = null;
        Boolean waitForDebugger = null;
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "targetInfo": {
                    targetInfo = (TargetInfo)input.read(TargetInfo.class);
                    continue block8;
                }
                case "waitingForDebugger": {
                    waitForDebugger = input.nextBoolean();
                    continue block8;
                }
            }
            input.skipValue();
        }
        return new AttachToTarget(sessionId, targetInfo, waitForDebugger);
    }
}

