/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.Initiator;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class WebSocketCreated {
    private final RequestId requestId;
    private final String url;
    private final Initiator initiator;

    public RequestId getRequestId() {
        return this.requestId;
    }

    public String getUrl() {
        return this.url;
    }

    public Initiator getInitiator() {
        return this.initiator;
    }

    private WebSocketCreated(RequestId requestId, String url, Initiator initiator) {
        this.requestId = Objects.requireNonNull(requestId, "'requestId' is required for WebSocketCreated");
        this.url = Objects.requireNonNull(url, "'url' is required for WebSocketCreated");
        this.initiator = initiator;
    }

    private static WebSocketCreated fromJson(JsonInput input) {
        RequestId requestId = new RequestId(input.nextString());
        String url = null;
        Initiator initiator = null;
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block8;
                }
                case "initiator": {
                    initiator = (Initiator)input.read(Initiator.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        return new WebSocketCreated(requestId, url, initiator);
    }
}

