/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.network.model.CallFrame;
import org.openqa.selenium.devtools.network.model.StackTraceId;
import org.openqa.selenium.json.JsonInput;

public class StackTrace {
    private String description;
    private List<CallFrame> callFrames;
    private StackTrace parent;
    private StackTraceId parentId;

    private StackTrace(String description, List<CallFrame> callFrames, StackTrace parent, StackTraceId parentId) {
        this.description = description;
        this.callFrames = Objects.requireNonNull(callFrames, "'callFrames' is required for StackTrace");
        this.parent = parent;
        this.parentId = parentId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<CallFrame> getCallFrames() {
        return this.callFrames;
    }

    public void setCallFrames(List<CallFrame> callFrames) {
        this.callFrames = callFrames;
    }

    public StackTrace getParent() {
        return this.parent;
    }

    public void setParent(StackTrace parent) {
        this.parent = parent;
    }

    public StackTraceId getParentId() {
        return this.parentId;
    }

    public void setParentId(StackTraceId parentId) {
        this.parentId = parentId;
    }

    private static StackTrace fromJson(JsonInput input) {
        input.beginObject();
        String description = null;
        ArrayList<CallFrame> callFrames = null;
        StackTrace parent = null;
        StackTraceId parentId = null;
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "description": {
                    description = input.nextString();
                    continue block8;
                }
                case "callFrames": {
                    input.beginArray();
                    callFrames = new ArrayList<CallFrame>();
                    while (input.hasNext()) {
                        callFrames.add((CallFrame)input.read(CallFrame.class));
                    }
                    input.endArray();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StackTrace(description, callFrames, parent, parentId);
    }
}

