/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.json.JsonInput;

public class SignedCertificateTimestamp {
    private String status;
    private String origin;
    private String logDescription;
    private String logId;
    private MonotonicTime timestamp;
    private String hashAlgorithm;
    private String signatureAlgorithm;
    private String signatureData;

    private SignedCertificateTimestamp(String status, String origin, String logDescription, String logId, MonotonicTime timestamp, String hashAlgorithm, String signatureAlgorithm, String signatureData) {
        this.status = Objects.requireNonNull(status, "'status' is required for SignedCertificateTimestamp");
        this.origin = Objects.requireNonNull(origin, "'origin' is required for SignedCertificateTimestamp");
        this.logDescription = Objects.requireNonNull(logDescription, "'logDescription' is required for SignedCertificateTimestamp");
        this.logId = Objects.requireNonNull(logId, "'logId' is required for SignedCertificateTimestamp");
        this.timestamp = Objects.requireNonNull(timestamp, "'timestamp' is required for SignedCertificateTimestamp");
        this.hashAlgorithm = Objects.requireNonNull(hashAlgorithm, "'hashAlgorithm' is required for SignedCertificateTimestamp");
        this.signatureAlgorithm = Objects.requireNonNull(signatureAlgorithm, "'signatureAlgorithm' is required for SignedCertificateTimestamp");
        this.signatureData = Objects.requireNonNull(signatureData, "'signatureData' is required for SignedCertificateTimestamp");
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getLogDescription() {
        return this.logDescription;
    }

    public void setLogDescription(String logDescription) {
        this.logDescription = logDescription;
    }

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(MonotonicTime timestamp) {
        this.timestamp = timestamp;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public String getSignatureData() {
        return this.signatureData;
    }

    public void setSignatureData(String signatureData) {
        this.signatureData = signatureData;
    }

    private static SignedCertificateTimestamp fromJson(JsonInput input) {
        String status = null;
        String origin = null;
        String logDescription = null;
        String logId = null;
        MonotonicTime timestamp = null;
        String hashAlgorithm = null;
        String signatureAlgorithm = null;
        String signatureData = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "status": {
                    status = input.nextString();
                    continue block20;
                }
                case "origin": {
                    origin = input.nextString();
                    continue block20;
                }
                case "logDescription": {
                    logDescription = input.nextString();
                    continue block20;
                }
                case "logId": {
                    logId = input.nextString();
                    continue block20;
                }
                case "timestamp": {
                    timestamp = MonotonicTime.parse(input.nextNumber());
                    continue block20;
                }
                case "hashAlgorithm": {
                    hashAlgorithm = input.nextString();
                    continue block20;
                }
                case "signatureAlgorithm": {
                    signatureAlgorithm = input.nextString();
                    continue block20;
                }
                case "signatureData": {
                    signatureData = input.nextString();
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SignedCertificateTimestamp(status, origin, logDescription, logId, timestamp, hashAlgorithm, signatureAlgorithm, signatureData);
    }
}

