/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.network.model.CertificateTransparencyCompliance;
import org.openqa.selenium.devtools.network.model.SignedCertificateTimestamp;
import org.openqa.selenium.json.JsonInput;

public class SecurityDetails {
    private String protocol;
    private String keyExchange;
    private String keyExchangeGroup;
    private String cipher;
    private String mac;
    private Integer certificateId;
    private String subjectName;
    private List<String> sanList;
    private String issuer;
    private Double validFrom;
    private Double validTo;
    private List<SignedCertificateTimestamp> signedCertificateTimestampList;
    private CertificateTransparencyCompliance certificateTransparencyCompliance;

    private SecurityDetails(String protocol, String keyExchange, String keyExchangeGroup, String cipher, String mac, Integer certificateId, String subjectName, List<String> sanList, String issuer, Double validFrom, Double validTo, List<SignedCertificateTimestamp> signedCertificateTimestampList, CertificateTransparencyCompliance certificateTransparencyCompliance) {
        this.protocol = Objects.requireNonNull(protocol, "'protocol' is required for SecurityDetails");
        this.keyExchange = Objects.requireNonNull(keyExchange, "'keyExchange' is required for SecurityDetails");
        this.keyExchangeGroup = keyExchangeGroup;
        this.cipher = Objects.requireNonNull(cipher, "'cipher' is required for SecurityDetails");
        this.mac = mac;
        this.certificateId = Objects.requireNonNull(certificateId, "'certificateId' is required for SecurityDetails");
        this.subjectName = Objects.requireNonNull(subjectName, "'subjectName' is required for SecurityDetails");
        this.sanList = Objects.requireNonNull(sanList, "'sanList' is required for SecurityDetails");
        this.issuer = Objects.requireNonNull(issuer, "'issuer' is required for SecurityDetails");
        this.validFrom = Objects.requireNonNull(validFrom, "'validFrom' is required for SecurityDetails");
        this.validTo = Objects.requireNonNull(validTo, "'validTo' is required for SecurityDetails");
        this.signedCertificateTimestampList = Objects.requireNonNull(signedCertificateTimestampList, "'signedCertificateTimestampList' is required for SecurityDetails");
        this.certificateTransparencyCompliance = Objects.requireNonNull(certificateTransparencyCompliance, "'certificateTransparencyCompliance' is required for SecurityDetails");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getKeyExchange() {
        return this.keyExchange;
    }

    public void setKeyExchange(String keyExchange) {
        this.keyExchange = keyExchange;
    }

    public String getKeyExchangeGroup() {
        return this.keyExchangeGroup;
    }

    public void setKeyExchangeGroup(String keyExchangeGroup) {
        this.keyExchangeGroup = keyExchangeGroup;
    }

    public String getCipher() {
        return this.cipher;
    }

    public void setCipher(String cipher) {
        this.cipher = cipher;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public Integer getCertificateId() {
        return this.certificateId;
    }

    public void setCertificateId(Integer certificateId) {
        this.certificateId = certificateId;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public List<String> getSanList() {
        return this.sanList;
    }

    public void setSanList(List<String> sanList) {
        this.sanList = sanList;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public Double getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Double validFrom) {
        this.validFrom = validFrom;
    }

    public Double getValidTo() {
        return this.validTo;
    }

    public void setValidTo(Double validTo) {
        this.validTo = validTo;
    }

    public List<SignedCertificateTimestamp> getSignedCertificateTimestampList() {
        return this.signedCertificateTimestampList;
    }

    public void setSignedCertificateTimestampList(List<SignedCertificateTimestamp> signedCertificateTimestampList) {
        this.signedCertificateTimestampList = signedCertificateTimestampList;
    }

    public CertificateTransparencyCompliance getCertificateTransparencyCompliance() {
        return this.certificateTransparencyCompliance;
    }

    public void setCertificateTransparencyCompliance(CertificateTransparencyCompliance certificateTransparencyCompliance) {
        this.certificateTransparencyCompliance = certificateTransparencyCompliance;
    }

    private static SecurityDetails fromJson(JsonInput input) {
        Object securityDetails = null;
        String protocol = null;
        String keyExchange = null;
        String keyExchangeGroup = null;
        String cipher = null;
        String mac = null;
        Number certificateId = null;
        String subjectName = null;
        ArrayList<String> sanList = null;
        String issuer = null;
        Number validFrom = null;
        Number validTo = null;
        List signedCertificateTimestampList = null;
        CertificateTransparencyCompliance certificateTransparencyCompliance = null;
        input.beginObject();
        block30: while (input.hasNext()) {
            switch (input.nextName()) {
                case "protocol": {
                    protocol = input.nextString();
                    continue block30;
                }
                case "keyExchange": {
                    keyExchange = input.nextString();
                    continue block30;
                }
                case "keyExchangeGroup": {
                    keyExchangeGroup = input.nextString();
                    continue block30;
                }
                case "cipher": {
                    cipher = input.nextString();
                    continue block30;
                }
                case "mac": {
                    mac = input.nextString();
                    continue block30;
                }
                case "certificateId": {
                    certificateId = input.nextNumber();
                    continue block30;
                }
                case "subjectName": {
                    subjectName = input.nextString();
                    continue block30;
                }
                case "sanList": {
                    input.beginArray();
                    sanList = new ArrayList<String>();
                    while (input.hasNext()) {
                        sanList.add(input.nextString());
                    }
                    input.endArray();
                    continue block30;
                }
                case "issuer": {
                    issuer = input.nextString();
                    continue block30;
                }
                case "validFrom": {
                    validFrom = input.nextNumber();
                    continue block30;
                }
                case "validTo": {
                    validTo = input.nextNumber();
                    continue block30;
                }
                case "signedCertificateTimestampList": {
                    signedCertificateTimestampList = (List)input.read(new TypeToken<List<SignedCertificateTimestamp>>(){}.getType());
                    continue block30;
                }
                case "certificateTransparencyCompliance": {
                    certificateTransparencyCompliance = CertificateTransparencyCompliance.fromString(input.nextString());
                    continue block30;
                }
            }
            input.skipValue();
        }
        return new SecurityDetails(protocol, keyExchange, keyExchangeGroup, cipher, mac, Integer.valueOf(String.valueOf(certificateId)), subjectName, sanList, issuer, validFrom != null ? Double.valueOf(String.valueOf(validFrom)) : null, validTo != null ? Double.valueOf(String.valueOf(validTo)) : null, signedCertificateTimestampList, certificateTransparencyCompliance);
    }
}

