/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.InitiatorType;
import org.openqa.selenium.devtools.network.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class Initiator {
    private InitiatorType type;
    private StackTrace stack;
    private String url;
    private Double lineNumber;

    private Initiator(InitiatorType type, StackTrace stack, String url, Double lineNumber) {
        this.type = Objects.requireNonNull(type, "'type' is required for Initiator");
        this.stack = stack;
        this.url = url;
        this.lineNumber = lineNumber;
    }

    public InitiatorType getType() {
        return this.type;
    }

    public void setType(InitiatorType type) {
        this.type = type;
    }

    public StackTrace getStack() {
        return this.stack;
    }

    public void setStack(StackTrace stack) {
        this.stack = stack;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Double getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Double lineNumber) {
        this.lineNumber = lineNumber;
    }

    private static Initiator fromJson(JsonInput input) {
        InitiatorType initiatorType = null;
        StackTrace stack = null;
        String initiatorUrl = null;
        Double lineNumber = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    initiatorType = InitiatorType.valueOf(input.nextString());
                    continue block12;
                }
                case "stack": {
                    stack = (StackTrace)input.read(StackTrace.class);
                    continue block12;
                }
                case "url": {
                    initiatorUrl = input.nextString();
                    continue block12;
                }
                case "lineNumber": {
                    lineNumber = (Double)input.read(Double.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Initiator(initiatorType, stack, initiatorUrl, lineNumber);
    }
}

