/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class DataReceived {
    private final RequestId requestId;
    private final MonotonicTime timestamp;
    private final Number dataLength;
    private final Number encodedDataLength;

    private DataReceived(RequestId requestId, MonotonicTime timestamp, Number dataLength, Number encodedDataLength) {
        this.requestId = requestId;
        this.timestamp = timestamp;
        this.dataLength = dataLength;
        this.encodedDataLength = encodedDataLength;
    }

    private static DataReceived fromJson(JsonInput input) {
        RequestId requestId = new RequestId(input.nextString());
        MonotonicTime timestamp = null;
        Number dataLength = null;
        Number encodedDataLength = null;
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "timestamp": {
                    timestamp = MonotonicTime.parse(input.nextNumber());
                    continue block10;
                }
                case "dataLength": {
                    dataLength = input.nextNumber();
                    continue block10;
                }
                case "encodedDataLength": {
                    encodedDataLength = input.nextNumber();
                    continue block10;
                }
            }
            input.skipValue();
        }
        return new DataReceived(requestId, timestamp, dataLength, encodedDataLength);
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public Number getDataLength() {
        return this.dataLength;
    }

    public Number getEncodedDataLength() {
        return this.encodedDataLength;
    }

    public String toString() {
        return "DataReceived{requestId='" + this.requestId.toString() + '\'' + ", timestamp=" + this.timestamp.getTimeStamp().toString() + ", dataLength=" + this.dataLength + ", encodedDataLength=" + this.encodedDataLength + '}';
    }
}

