/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.fetch;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.fetch.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.fetch.model.AuthRequired;
import org.openqa.selenium.devtools.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.fetch.model.RequestId;
import org.openqa.selenium.devtools.fetch.model.RequestPattern;
import org.openqa.selenium.devtools.fetch.model.RequestPaused;
import org.openqa.selenium.devtools.fetch.model.ResponseBody;
import org.openqa.selenium.devtools.io.model.StreamHandle;
import org.openqa.selenium.devtools.network.model.ErrorReason;

@Beta
public class Fetch {
    public static Command<Void> disable() {
        return new Command<Void>("Fetch.disable", (Map<String, Object>)ImmutableMap.of());
    }

    public static Command<Void> enable(Optional<List<RequestPattern>> patterns, Optional<Boolean> handleAuthRequests) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        patterns.ifPresent(p -> params.put((Object)"patterns", p));
        handleAuthRequests.ifPresent(h -> params.put((Object)"handleAuthRequests", h));
        return new Command<Void>("Fetch.enable", (Map<String, Object>)params.build());
    }

    public static Command<Void> failRequest(RequestId requestId, ErrorReason errorReason) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(errorReason, "errorReason is required");
        return new Command<Void>("Fetch.failRequest", (Map<String, Object>)ImmutableMap.of((Object)"requestId", (Object)requestId.toString(), (Object)"errorReason", (Object)((Object)errorReason)));
    }

    public static Command<Void> fulfillRequest(RequestId requestId, int responseCode, List<HeaderEntry> responseHeaders, Optional<String> body, Optional<String> responsePhrase) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        Objects.requireNonNull(requestId, "requestId is required");
        if (responseCode < 0) {
            throw new DevToolsException("Invalid http responseCode");
        }
        responseHeaders = Fetch.validateHeaders(responseHeaders);
        params.put((Object)"requestId", (Object)requestId.toString());
        params.put((Object)"responseHeaders", responseHeaders);
        params.put((Object)"responseCode", (Object)responseCode);
        body.ifPresent(b -> params.put((Object)"body", b));
        responsePhrase.ifPresent(phrase -> params.put((Object)"responsePhrase", phrase));
        return new Command<Void>("Fetch.fulfillRequest", (Map<String, Object>)params.build());
    }

    public static Command<Void> continueRequest(RequestId requestId, Optional<String> url, Optional<String> method, Optional<String> postData, Optional<List<HeaderEntry>> headers) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        Objects.requireNonNull(requestId, "requestId is required");
        params.put((Object)"requestId", (Object)requestId.toString());
        url.ifPresent(s -> params.put((Object)"url", s));
        method.ifPresent(s -> params.put((Object)"method", s));
        postData.ifPresent(s -> params.put((Object)"postData", s));
        headers.ifPresent(h -> params.put((Object)"headers", h));
        return new Command<Void>("Fetch.continueRequest", (Map<String, Object>)params.build());
    }

    public static Command<Void> continueWithAuth(RequestId requestId, AuthChallengeResponse authChallengeResponse) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(authChallengeResponse, "authChallengeResponse is required");
        return new Command<Void>("Fetch.continueWithAuth", (Map<String, Object>)ImmutableMap.of((Object)"requestId", (Object)requestId.toString(), (Object)"authChallengeResponse", (Object)authChallengeResponse));
    }

    public static Command<ResponseBody> getResponseBody(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        return new Command<ResponseBody>("Fetch.getResponseBody", (Map<String, Object>)ImmutableMap.of((Object)"requestId", (Object)requestId.toString()), ConverterFunctions.map("body", ResponseBody.class));
    }

    public static Command<StreamHandle> takeResponseBodyAsStream(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        return new Command<StreamHandle>("Fetch.takeResponseBodyAsStream", (Map<String, Object>)ImmutableMap.of((Object)"requestId", (Object)requestId.toString()), ConverterFunctions.map("stream", StreamHandle.class));
    }

    public static Event<RequestPaused> requestPaused() {
        return new Event<RequestPaused>("Fetch.requestPaused", ConverterFunctions.map("requestId", RequestPaused.class));
    }

    public static Event<AuthRequired> authRequired() {
        return new Event<AuthRequired>("Fetch.authRequired", ConverterFunctions.map("requestId", AuthRequired.class));
    }

    private static List<HeaderEntry> validateHeaders(List<HeaderEntry> responseHeaders) {
        Objects.requireNonNull(responseHeaders, "responseHeaders is required");
        if (responseHeaders.isEmpty()) {
            throw new DevToolsException("responseHeaders is empty");
        }
        responseHeaders.forEach(Fetch::validateHeader);
        return responseHeaders;
    }

    private static HeaderEntry validateHeader(HeaderEntry responseHeader) {
        return Objects.requireNonNull(responseHeader, "responseHeader is required");
    }
}

