/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.applicationCache.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.applicationCache.model.ApplicationCacheResource;
import org.openqa.selenium.json.JsonInput;

public class ApplicationCacheModel {
    private final String manifestURL;
    private final double size;
    private final double creationTime;
    private final double updateTime;
    private final List<ApplicationCacheResource> resources;

    public ApplicationCacheModel(String manifestURL, double size, double creationTime, double updateTime, List<ApplicationCacheResource> resources) {
        this.manifestURL = Objects.requireNonNull(manifestURL, "manifestURL is required");
        this.size = Objects.requireNonNull(Double.valueOf(size), "size is required");
        this.creationTime = Objects.requireNonNull(Double.valueOf(creationTime), "creationTime is required");
        this.updateTime = Objects.requireNonNull(Double.valueOf(updateTime), "updateTime is required");
        this.resources = this.validateResources(resources);
    }

    private static ApplicationCacheModel fromJson(JsonInput input) {
        String manifestURL = input.nextString();
        Double size = null;
        Double creationTime = null;
        Double updateTime = null;
        ArrayList<ApplicationCacheResource> resources = null;
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "size": {
                    size = (Double)input.read(Double.class);
                    continue block12;
                }
                case "creationTime": {
                    creationTime = (Double)input.read(Double.class);
                    continue block12;
                }
                case "updateTime": {
                    updateTime = (Double)input.read(Double.class);
                    continue block12;
                }
                case "resources": {
                    resources = new ArrayList<ApplicationCacheResource>();
                    input.beginArray();
                    while (input.hasNext()) {
                        resources.add((ApplicationCacheResource)input.read(ApplicationCacheResource.class));
                    }
                    input.endArray();
                    continue block12;
                }
            }
            input.skipValue();
        }
        return new ApplicationCacheModel(manifestURL, size, creationTime, updateTime, resources);
    }

    private List<ApplicationCacheResource> validateResources(List<ApplicationCacheResource> resources) {
        Objects.requireNonNull(resources, "resources is required");
        if (resources.isEmpty()) {
            throw new DevToolsException("resources is empty");
        }
        return resources;
    }

    public String getManifestURL() {
        return this.manifestURL;
    }

    public double getSize() {
        return this.size;
    }

    public double getCreationTime() {
        return this.creationTime;
    }

    public double getUpdateTime() {
        return this.updateTime;
    }

    public List<ApplicationCacheResource> getResources() {
        return this.resources;
    }
}

