/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.applicationCache;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.applicationCache.model.ApplicationCacheModel;
import org.openqa.selenium.devtools.applicationCache.model.ApplicationCacheStatusUpdated;
import org.openqa.selenium.devtools.applicationCache.model.FrameWithManifest;
import org.openqa.selenium.devtools.page.model.FrameId;

public class ApplicationCache {
    public static Command<Void> enable() {
        return new Command<Void>("ApplicationCache.enable", (Map<String, Object>)ImmutableMap.of());
    }

    public static Command<ApplicationCacheModel> getApplicationCacheForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        return new Command<ApplicationCacheModel>("ApplicationCache.getApplicationCacheForFrame", (Map<String, Object>)ImmutableMap.of((Object)"frameId", (Object)frameId), ConverterFunctions.map("applicationCache", ApplicationCacheModel.class));
    }

    public static Command<List<FrameWithManifest>> getFramesWithManifests() {
        return new Command<List<FrameWithManifest>>("ApplicationCache.getFramesWithManifests", (Map<String, Object>)ImmutableMap.of(), ConverterFunctions.map("frameIds", new TypeToken<List<FrameWithManifest>>(){}.getType()));
    }

    public static Command<String> getManifestForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        return new Command<String>("ApplicationCache.getManifestForFrame", (Map<String, Object>)ImmutableMap.of((Object)"frameId", (Object)frameId), ConverterFunctions.map("manifestURL", String.class));
    }

    public static Event<ApplicationCacheStatusUpdated> applicationCacheStatusUpdated() {
        return new Event<ApplicationCacheStatusUpdated>("ApplicationCache.applicationCacheStatusUpdated", ConverterFunctions.map("frameId", ApplicationCacheStatusUpdated.class));
    }

    public static Event<Boolean> networkStateUpdated() {
        return new Event<Boolean>("ApplicationCache.networkStateUpdated", ConverterFunctions.map("isNowOnline", Boolean.class));
    }
}

