/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v99.browser.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum WindowState {
    NORMAL("normal"),
    MINIMIZED("minimized"),
    MAXIMIZED("maximized"),
    FULLSCREEN("fullscreen");

    private String value;

    private WindowState(String value) {
        this.value = value;
    }

    public static WindowState fromString(String s) {
        return Arrays.stream(WindowState.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within WindowState "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static WindowState fromJson(JsonInput input) {
        return WindowState.fromString(input.nextString());
    }
}

