package org.openqa.selenium.devtools.v99.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This issue tracks information needed to print a deprecation message.
 * The formatting is inherited from the old console.log version, see more at:
 * https://source.chromium.org/chromium/chromium/src/+/main:third_party/blink/renderer/core/frame/deprecation.cc
 * TODO(crbug.com/1264960): Re-work format to add i18n support per:
 * https://source.chromium.org/chromium/chromium/src/+/main:third_party/blink/public/devtools_protocol/README.md
 */
public class DeprecationIssueDetails {

    private final java.util.Optional<org.openqa.selenium.devtools.v99.audits.model.AffectedFrame> affectedFrame;

    private final org.openqa.selenium.devtools.v99.audits.model.SourceCodeLocation sourceCodeLocation;

    private final java.util.Optional<java.lang.String> message;

    private final java.lang.String deprecationType;

    public DeprecationIssueDetails(java.util.Optional<org.openqa.selenium.devtools.v99.audits.model.AffectedFrame> affectedFrame, org.openqa.selenium.devtools.v99.audits.model.SourceCodeLocation sourceCodeLocation, java.util.Optional<java.lang.String> message, java.lang.String deprecationType) {
        this.affectedFrame = affectedFrame;
        this.sourceCodeLocation = java.util.Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.message = message;
        this.deprecationType = java.util.Objects.requireNonNull(deprecationType, "deprecationType is required");
    }

    public java.util.Optional<org.openqa.selenium.devtools.v99.audits.model.AffectedFrame> getAffectedFrame() {
        return affectedFrame;
    }

    public org.openqa.selenium.devtools.v99.audits.model.SourceCodeLocation getSourceCodeLocation() {
        return sourceCodeLocation;
    }

    /**
     * The content of the deprecation issue (this won't be translated),
     * e.g. "window.inefficientLegacyStorageMethod will be removed in M97,
     * around January 2022. Please use Web Storage or Indexed Database
     * instead. This standard was abandoned in January, 1970. See
     * https://www.chromestatus.com/feature/5684870116278272 for more details."
     */
    @Deprecated()
    public java.util.Optional<java.lang.String> getMessage() {
        return message;
    }

    public java.lang.String getDeprecationType() {
        return deprecationType;
    }

    private static DeprecationIssueDetails fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v99.audits.model.AffectedFrame> affectedFrame = java.util.Optional.empty();
        org.openqa.selenium.devtools.v99.audits.model.SourceCodeLocation sourceCodeLocation = null;
        java.util.Optional<java.lang.String> message = java.util.Optional.empty();
        java.lang.String deprecationType = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "affectedFrame":
                    affectedFrame = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v99.audits.model.AffectedFrame.class));
                    break;
                case "sourceCodeLocation":
                    sourceCodeLocation = input.read(org.openqa.selenium.devtools.v99.audits.model.SourceCodeLocation.class);
                    break;
                case "message":
                    message = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "deprecationType":
                    deprecationType = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DeprecationIssueDetails(affectedFrame, sourceCodeLocation, message, deprecationType);
    }
}
