package org.openqa.selenium.devtools.v99.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Details for a CORS related issue, e.g. a warning or error related to
 * CORS RFC1918 enforcement.
 */
public class CorsIssueDetails {

    private final org.openqa.selenium.devtools.v99.network.model.CorsErrorStatus corsErrorStatus;

    private final java.lang.Boolean isWarning;

    private final org.openqa.selenium.devtools.v99.audits.model.AffectedRequest request;

    private final java.util.Optional<org.openqa.selenium.devtools.v99.audits.model.SourceCodeLocation> location;

    private final java.util.Optional<java.lang.String> initiatorOrigin;

    private final java.util.Optional<org.openqa.selenium.devtools.v99.network.model.IPAddressSpace> resourceIPAddressSpace;

    private final java.util.Optional<org.openqa.selenium.devtools.v99.network.model.ClientSecurityState> clientSecurityState;

    public CorsIssueDetails(org.openqa.selenium.devtools.v99.network.model.CorsErrorStatus corsErrorStatus, java.lang.Boolean isWarning, org.openqa.selenium.devtools.v99.audits.model.AffectedRequest request, java.util.Optional<org.openqa.selenium.devtools.v99.audits.model.SourceCodeLocation> location, java.util.Optional<java.lang.String> initiatorOrigin, java.util.Optional<org.openqa.selenium.devtools.v99.network.model.IPAddressSpace> resourceIPAddressSpace, java.util.Optional<org.openqa.selenium.devtools.v99.network.model.ClientSecurityState> clientSecurityState) {
        this.corsErrorStatus = java.util.Objects.requireNonNull(corsErrorStatus, "corsErrorStatus is required");
        this.isWarning = java.util.Objects.requireNonNull(isWarning, "isWarning is required");
        this.request = java.util.Objects.requireNonNull(request, "request is required");
        this.location = location;
        this.initiatorOrigin = initiatorOrigin;
        this.resourceIPAddressSpace = resourceIPAddressSpace;
        this.clientSecurityState = clientSecurityState;
    }

    public org.openqa.selenium.devtools.v99.network.model.CorsErrorStatus getCorsErrorStatus() {
        return corsErrorStatus;
    }

    public java.lang.Boolean getIsWarning() {
        return isWarning;
    }

    public org.openqa.selenium.devtools.v99.audits.model.AffectedRequest getRequest() {
        return request;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v99.audits.model.SourceCodeLocation> getLocation() {
        return location;
    }

    public java.util.Optional<java.lang.String> getInitiatorOrigin() {
        return initiatorOrigin;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v99.network.model.IPAddressSpace> getResourceIPAddressSpace() {
        return resourceIPAddressSpace;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v99.network.model.ClientSecurityState> getClientSecurityState() {
        return clientSecurityState;
    }

    private static CorsIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v99.network.model.CorsErrorStatus corsErrorStatus = null;
        java.lang.Boolean isWarning = false;
        org.openqa.selenium.devtools.v99.audits.model.AffectedRequest request = null;
        java.util.Optional<org.openqa.selenium.devtools.v99.audits.model.SourceCodeLocation> location = java.util.Optional.empty();
        java.util.Optional<java.lang.String> initiatorOrigin = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v99.network.model.IPAddressSpace> resourceIPAddressSpace = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v99.network.model.ClientSecurityState> clientSecurityState = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "corsErrorStatus":
                    corsErrorStatus = input.read(org.openqa.selenium.devtools.v99.network.model.CorsErrorStatus.class);
                    break;
                case "isWarning":
                    isWarning = input.nextBoolean();
                    break;
                case "request":
                    request = input.read(org.openqa.selenium.devtools.v99.audits.model.AffectedRequest.class);
                    break;
                case "location":
                    location = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v99.audits.model.SourceCodeLocation.class));
                    break;
                case "initiatorOrigin":
                    initiatorOrigin = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "resourceIPAddressSpace":
                    resourceIPAddressSpace = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v99.network.model.IPAddressSpace.class));
                    break;
                case "clientSecurityState":
                    clientSecurityState = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v99.network.model.ClientSecurityState.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CorsIssueDetails(corsErrorStatus, isWarning, request, location, initiatorOrigin, resourceIPAddressSpace, clientSecurityState);
    }
}
