/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v98.domstorage;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v98.domstorage.model.DomStorageItemAdded;
import org.openqa.selenium.devtools.v98.domstorage.model.DomStorageItemRemoved;
import org.openqa.selenium.devtools.v98.domstorage.model.DomStorageItemUpdated;
import org.openqa.selenium.devtools.v98.domstorage.model.Item;
import org.openqa.selenium.devtools.v98.domstorage.model.StorageId;

@Beta
public class DOMStorage {
    public static Command<Void> clear(StorageId storageId) {
        Objects.requireNonNull(storageId, "storageId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"storageId", (Object)storageId);
        return new Command("DOMStorage.clear", (Map)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("DOMStorage.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("DOMStorage.enable", (Map)params.build());
    }

    public static Command<List<Item>> getDOMStorageItems(StorageId storageId) {
        Objects.requireNonNull(storageId, "storageId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"storageId", (Object)storageId);
        return new Command("DOMStorage.getDOMStorageItems", (Map)params.build(), ConverterFunctions.map((String)"entries", (Type)new TypeToken<List<Item>>(){}.getType()));
    }

    public static Command<Void> removeDOMStorageItem(StorageId storageId, String key) {
        Objects.requireNonNull(storageId, "storageId is required");
        Objects.requireNonNull(key, "key is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"storageId", (Object)storageId);
        params.put((Object)"key", (Object)key);
        return new Command("DOMStorage.removeDOMStorageItem", (Map)params.build());
    }

    public static Command<Void> setDOMStorageItem(StorageId storageId, String key, String value) {
        Objects.requireNonNull(storageId, "storageId is required");
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"storageId", (Object)storageId);
        params.put((Object)"key", (Object)key);
        params.put((Object)"value", (Object)value);
        return new Command("DOMStorage.setDOMStorageItem", (Map)params.build());
    }

    public static Event<DomStorageItemAdded> domStorageItemAdded() {
        return new Event("DOMStorage.domStorageItemAdded", input -> (DomStorageItemAdded)input.read(DomStorageItemAdded.class));
    }

    public static Event<DomStorageItemRemoved> domStorageItemRemoved() {
        return new Event("DOMStorage.domStorageItemRemoved", input -> (DomStorageItemRemoved)input.read(DomStorageItemRemoved.class));
    }

    public static Event<DomStorageItemUpdated> domStorageItemUpdated() {
        return new Event("DOMStorage.domStorageItemUpdated", input -> (DomStorageItemUpdated)input.read(DomStorageItemUpdated.class));
    }

    public static Event<StorageId> domStorageItemsCleared() {
        return new Event("DOMStorage.domStorageItemsCleared", ConverterFunctions.map((String)"storageId", StorageId.class));
    }
}

