/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v98.cachestorage.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v98.cachestorage.model.CacheId;
import org.openqa.selenium.json.JsonInput;

public class Cache {
    private final CacheId cacheId;
    private final String securityOrigin;
    private final String cacheName;

    public Cache(CacheId cacheId, String securityOrigin, String cacheName) {
        this.cacheId = Objects.requireNonNull(cacheId, "cacheId is required");
        this.securityOrigin = Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        this.cacheName = Objects.requireNonNull(cacheName, "cacheName is required");
    }

    public CacheId getCacheId() {
        return this.cacheId;
    }

    public String getSecurityOrigin() {
        return this.securityOrigin;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    private static Cache fromJson(JsonInput input) {
        CacheId cacheId = null;
        String securityOrigin = null;
        String cacheName = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "cacheId": {
                    cacheId = (CacheId)input.read(CacheId.class);
                    continue block10;
                }
                case "securityOrigin": {
                    securityOrigin = input.nextString();
                    continue block10;
                }
                case "cacheName": {
                    cacheName = input.nextString();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Cache(cacheId, securityOrigin, cacheName);
    }
}

