package org.openqa.selenium.devtools.v98.debugger.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Location range within one script.
 */
@org.openqa.selenium.Beta()
public class LocationRange {

    private final org.openqa.selenium.devtools.v98.runtime.model.ScriptId scriptId;

    private final org.openqa.selenium.devtools.v98.debugger.model.ScriptPosition start;

    private final org.openqa.selenium.devtools.v98.debugger.model.ScriptPosition end;

    public LocationRange(org.openqa.selenium.devtools.v98.runtime.model.ScriptId scriptId, org.openqa.selenium.devtools.v98.debugger.model.ScriptPosition start, org.openqa.selenium.devtools.v98.debugger.model.ScriptPosition end) {
        this.scriptId = java.util.Objects.requireNonNull(scriptId, "scriptId is required");
        this.start = java.util.Objects.requireNonNull(start, "start is required");
        this.end = java.util.Objects.requireNonNull(end, "end is required");
    }

    public org.openqa.selenium.devtools.v98.runtime.model.ScriptId getScriptId() {
        return scriptId;
    }

    public org.openqa.selenium.devtools.v98.debugger.model.ScriptPosition getStart() {
        return start;
    }

    public org.openqa.selenium.devtools.v98.debugger.model.ScriptPosition getEnd() {
        return end;
    }

    private static LocationRange fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v98.runtime.model.ScriptId scriptId = null;
        org.openqa.selenium.devtools.v98.debugger.model.ScriptPosition start = null;
        org.openqa.selenium.devtools.v98.debugger.model.ScriptPosition end = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "scriptId":
                    scriptId = input.read(org.openqa.selenium.devtools.v98.runtime.model.ScriptId.class);
                    break;
                case "start":
                    start = input.read(org.openqa.selenium.devtools.v98.debugger.model.ScriptPosition.class);
                    break;
                case "end":
                    end = input.read(org.openqa.selenium.devtools.v98.debugger.model.ScriptPosition.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new LocationRange(scriptId, start, end);
    }
}
