package org.openqa.selenium.devtools.v98.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A unique id for a DevTools inspector issue. Allows other entities (e.g.
 * exceptions, CDP message, console messages, etc.) to reference an issue.
 */
public class IssueId {

    private final java.lang.String issueId;

    public IssueId(java.lang.String issueId) {
        this.issueId = java.util.Objects.requireNonNull(issueId, "Missing value for IssueId");
    }

    private static IssueId fromJson(JsonInput input) {
        return new IssueId(input.nextString());
    }

    public String toJson() {
        return issueId.toString();
    }

    public String toString() {
        return issueId.toString();
    }
}
