/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v97.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v97.audits.model.AffectedFrame;
import org.openqa.selenium.devtools.v97.audits.model.SourceCodeLocation;
import org.openqa.selenium.json.JsonInput;

public class DeprecationIssueDetails {
    private final Optional<AffectedFrame> affectedFrame;
    private final SourceCodeLocation sourceCodeLocation;
    private final Optional<String> message;

    public DeprecationIssueDetails(Optional<AffectedFrame> affectedFrame, SourceCodeLocation sourceCodeLocation, Optional<String> message) {
        this.affectedFrame = affectedFrame;
        this.sourceCodeLocation = Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.message = message;
    }

    public Optional<AffectedFrame> getAffectedFrame() {
        return this.affectedFrame;
    }

    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    @Deprecated
    public Optional<String> getMessage() {
        return this.message;
    }

    private static DeprecationIssueDetails fromJson(JsonInput input) {
        Optional<AffectedFrame> affectedFrame = Optional.empty();
        SourceCodeLocation sourceCodeLocation = null;
        Optional<String> message = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "affectedFrame": {
                    affectedFrame = Optional.ofNullable((AffectedFrame)input.read(AffectedFrame.class));
                    continue block10;
                }
                case "sourceCodeLocation": {
                    sourceCodeLocation = (SourceCodeLocation)input.read(SourceCodeLocation.class);
                    continue block10;
                }
                case "message": {
                    message = Optional.ofNullable(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DeprecationIssueDetails(affectedFrame, sourceCodeLocation, message);
    }
}

