package org.openqa.selenium.devtools.v97.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The referring-policy used for the navigation.
 */
@org.openqa.selenium.Beta()
public enum ReferrerPolicy {

    NOREFERRER("noReferrer"),
    NOREFERRERWHENDOWNGRADE("noReferrerWhenDowngrade"),
    ORIGIN("origin"),
    ORIGINWHENCROSSORIGIN("originWhenCrossOrigin"),
    SAMEORIGIN("sameOrigin"),
    STRICTORIGIN("strictOrigin"),
    STRICTORIGINWHENCROSSORIGIN("strictOriginWhenCrossOrigin"),
    UNSAFEURL("unsafeUrl");

    private String value;

    ReferrerPolicy(String value) {
        this.value = value;
    }

    public static ReferrerPolicy fromString(String s) {
        return java.util.Arrays.stream(ReferrerPolicy.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ReferrerPolicy "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ReferrerPolicy fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
