package org.openqa.selenium.devtools.v96.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class ContentSecurityPolicyIssueDetails {

    private final java.util.Optional<java.lang.String> blockedURL;

    private final java.lang.String violatedDirective;

    private final java.lang.Boolean isReportOnly;

    private final org.openqa.selenium.devtools.v96.audits.model.ContentSecurityPolicyViolationType contentSecurityPolicyViolationType;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.audits.model.AffectedFrame> frameAncestor;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.audits.model.SourceCodeLocation> sourceCodeLocation;

    private final java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.BackendNodeId> violatingNodeId;

    public ContentSecurityPolicyIssueDetails(java.util.Optional<java.lang.String> blockedURL, java.lang.String violatedDirective, java.lang.Boolean isReportOnly, org.openqa.selenium.devtools.v96.audits.model.ContentSecurityPolicyViolationType contentSecurityPolicyViolationType, java.util.Optional<org.openqa.selenium.devtools.v96.audits.model.AffectedFrame> frameAncestor, java.util.Optional<org.openqa.selenium.devtools.v96.audits.model.SourceCodeLocation> sourceCodeLocation, java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.BackendNodeId> violatingNodeId) {
        this.blockedURL = blockedURL;
        this.violatedDirective = java.util.Objects.requireNonNull(violatedDirective, "violatedDirective is required");
        this.isReportOnly = java.util.Objects.requireNonNull(isReportOnly, "isReportOnly is required");
        this.contentSecurityPolicyViolationType = java.util.Objects.requireNonNull(contentSecurityPolicyViolationType, "contentSecurityPolicyViolationType is required");
        this.frameAncestor = frameAncestor;
        this.sourceCodeLocation = sourceCodeLocation;
        this.violatingNodeId = violatingNodeId;
    }

    /**
     * The url not included in allowed sources.
     */
    public java.util.Optional<java.lang.String> getBlockedURL() {
        return blockedURL;
    }

    /**
     * Specific directive that is violated, causing the CSP issue.
     */
    public java.lang.String getViolatedDirective() {
        return violatedDirective;
    }

    public java.lang.Boolean getIsReportOnly() {
        return isReportOnly;
    }

    public org.openqa.selenium.devtools.v96.audits.model.ContentSecurityPolicyViolationType getContentSecurityPolicyViolationType() {
        return contentSecurityPolicyViolationType;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v96.audits.model.AffectedFrame> getFrameAncestor() {
        return frameAncestor;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v96.audits.model.SourceCodeLocation> getSourceCodeLocation() {
        return sourceCodeLocation;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.BackendNodeId> getViolatingNodeId() {
        return violatingNodeId;
    }

    private static ContentSecurityPolicyIssueDetails fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> blockedURL = java.util.Optional.empty();
        java.lang.String violatedDirective = null;
        java.lang.Boolean isReportOnly = false;
        org.openqa.selenium.devtools.v96.audits.model.ContentSecurityPolicyViolationType contentSecurityPolicyViolationType = null;
        java.util.Optional<org.openqa.selenium.devtools.v96.audits.model.AffectedFrame> frameAncestor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v96.audits.model.SourceCodeLocation> sourceCodeLocation = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v96.dom.model.BackendNodeId> violatingNodeId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "blockedURL":
                    blockedURL = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "violatedDirective":
                    violatedDirective = input.nextString();
                    break;
                case "isReportOnly":
                    isReportOnly = input.nextBoolean();
                    break;
                case "contentSecurityPolicyViolationType":
                    contentSecurityPolicyViolationType = input.read(org.openqa.selenium.devtools.v96.audits.model.ContentSecurityPolicyViolationType.class);
                    break;
                case "frameAncestor":
                    frameAncestor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.audits.model.AffectedFrame.class));
                    break;
                case "sourceCodeLocation":
                    sourceCodeLocation = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.audits.model.SourceCodeLocation.class));
                    break;
                case "violatingNodeId":
                    violatingNodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v96.dom.model.BackendNodeId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ContentSecurityPolicyIssueDetails(blockedURL, violatedDirective, isReportOnly, contentSecurityPolicyViolationType, frameAncestor, sourceCodeLocation, violatingNodeId);
    }
}
