/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v94.runtime;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v94.runtime.model.BindingCalled;
import org.openqa.selenium.devtools.v94.runtime.model.CallArgument;
import org.openqa.selenium.devtools.v94.runtime.model.ConsoleAPICalled;
import org.openqa.selenium.devtools.v94.runtime.model.ExceptionDetails;
import org.openqa.selenium.devtools.v94.runtime.model.ExceptionRevoked;
import org.openqa.selenium.devtools.v94.runtime.model.ExceptionThrown;
import org.openqa.selenium.devtools.v94.runtime.model.ExecutionContextDescription;
import org.openqa.selenium.devtools.v94.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.v94.runtime.model.InspectRequested;
import org.openqa.selenium.devtools.v94.runtime.model.InternalPropertyDescriptor;
import org.openqa.selenium.devtools.v94.runtime.model.PrivatePropertyDescriptor;
import org.openqa.selenium.devtools.v94.runtime.model.PropertyDescriptor;
import org.openqa.selenium.devtools.v94.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v94.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.v94.runtime.model.ScriptId;
import org.openqa.selenium.devtools.v94.runtime.model.TimeDelta;
import org.openqa.selenium.json.JsonInput;

public class Runtime {
    public static Command<AwaitPromiseResponse> awaitPromise(RemoteObjectId promiseObjectId, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview) {
        Objects.requireNonNull(promiseObjectId, "promiseObjectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"promiseObjectId", (Object)promiseObjectId);
        returnByValue.ifPresent(p -> params.put((Object)"returnByValue", p));
        generatePreview.ifPresent(p -> params.put((Object)"generatePreview", p));
        return new Command("Runtime.awaitPromise", (Map)params.build(), input -> (AwaitPromiseResponse)input.read(AwaitPromiseResponse.class));
    }

    public static Command<CallFunctionOnResponse> callFunctionOn(String functionDeclaration, Optional<RemoteObjectId> objectId, Optional<List<CallArgument>> arguments, Optional<Boolean> silent, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> userGesture, Optional<Boolean> awaitPromise, Optional<ExecutionContextId> executionContextId, Optional<String> objectGroup, Optional<Boolean> throwOnSideEffect) {
        Objects.requireNonNull(functionDeclaration, "functionDeclaration is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"functionDeclaration", (Object)functionDeclaration);
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        arguments.ifPresent(p -> params.put((Object)"arguments", p));
        silent.ifPresent(p -> params.put((Object)"silent", p));
        returnByValue.ifPresent(p -> params.put((Object)"returnByValue", p));
        generatePreview.ifPresent(p -> params.put((Object)"generatePreview", p));
        userGesture.ifPresent(p -> params.put((Object)"userGesture", p));
        awaitPromise.ifPresent(p -> params.put((Object)"awaitPromise", p));
        executionContextId.ifPresent(p -> params.put((Object)"executionContextId", p));
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        throwOnSideEffect.ifPresent(p -> params.put((Object)"throwOnSideEffect", p));
        return new Command("Runtime.callFunctionOn", (Map)params.build(), input -> (CallFunctionOnResponse)input.read(CallFunctionOnResponse.class));
    }

    public static Command<CompileScriptResponse> compileScript(String expression, String sourceURL, Boolean persistScript, Optional<ExecutionContextId> executionContextId) {
        Objects.requireNonNull(expression, "expression is required");
        Objects.requireNonNull(sourceURL, "sourceURL is required");
        Objects.requireNonNull(persistScript, "persistScript is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"expression", (Object)expression);
        params.put((Object)"sourceURL", (Object)sourceURL);
        params.put((Object)"persistScript", (Object)persistScript);
        executionContextId.ifPresent(p -> params.put((Object)"executionContextId", p));
        return new Command("Runtime.compileScript", (Map)params.build(), input -> (CompileScriptResponse)input.read(CompileScriptResponse.class));
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Runtime.disable", (Map)params.build());
    }

    public static Command<Void> discardConsoleEntries() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Runtime.discardConsoleEntries", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Runtime.enable", (Map)params.build());
    }

    public static Command<EvaluateResponse> evaluate(String expression, Optional<String> objectGroup, Optional<Boolean> includeCommandLineAPI, Optional<Boolean> silent, Optional<ExecutionContextId> contextId, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> userGesture, Optional<Boolean> awaitPromise, Optional<Boolean> throwOnSideEffect, Optional<TimeDelta> timeout, Optional<Boolean> disableBreaks, Optional<Boolean> replMode, Optional<Boolean> allowUnsafeEvalBlockedByCSP, Optional<String> uniqueContextId) {
        Objects.requireNonNull(expression, "expression is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"expression", (Object)expression);
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        includeCommandLineAPI.ifPresent(p -> params.put((Object)"includeCommandLineAPI", p));
        silent.ifPresent(p -> params.put((Object)"silent", p));
        contextId.ifPresent(p -> params.put((Object)"contextId", p));
        returnByValue.ifPresent(p -> params.put((Object)"returnByValue", p));
        generatePreview.ifPresent(p -> params.put((Object)"generatePreview", p));
        userGesture.ifPresent(p -> params.put((Object)"userGesture", p));
        awaitPromise.ifPresent(p -> params.put((Object)"awaitPromise", p));
        throwOnSideEffect.ifPresent(p -> params.put((Object)"throwOnSideEffect", p));
        timeout.ifPresent(p -> params.put((Object)"timeout", p));
        disableBreaks.ifPresent(p -> params.put((Object)"disableBreaks", p));
        replMode.ifPresent(p -> params.put((Object)"replMode", p));
        allowUnsafeEvalBlockedByCSP.ifPresent(p -> params.put((Object)"allowUnsafeEvalBlockedByCSP", p));
        uniqueContextId.ifPresent(p -> params.put((Object)"uniqueContextId", p));
        return new Command("Runtime.evaluate", (Map)params.build(), input -> (EvaluateResponse)input.read(EvaluateResponse.class));
    }

    @Beta
    public static Command<String> getIsolateId() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Runtime.getIsolateId", (Map)params.build(), ConverterFunctions.map((String)"id", String.class));
    }

    @Beta
    public static Command<GetHeapUsageResponse> getHeapUsage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Runtime.getHeapUsage", (Map)params.build(), input -> (GetHeapUsageResponse)input.read(GetHeapUsageResponse.class));
    }

    public static Command<GetPropertiesResponse> getProperties(RemoteObjectId objectId, Optional<Boolean> ownProperties, Optional<Boolean> accessorPropertiesOnly, Optional<Boolean> generatePreview) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        ownProperties.ifPresent(p -> params.put((Object)"ownProperties", p));
        accessorPropertiesOnly.ifPresent(p -> params.put((Object)"accessorPropertiesOnly", p));
        generatePreview.ifPresent(p -> params.put((Object)"generatePreview", p));
        return new Command("Runtime.getProperties", (Map)params.build(), input -> (GetPropertiesResponse)input.read(GetPropertiesResponse.class));
    }

    public static Command<List<String>> globalLexicalScopeNames(Optional<ExecutionContextId> executionContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        executionContextId.ifPresent(p -> params.put((Object)"executionContextId", p));
        return new Command("Runtime.globalLexicalScopeNames", (Map)params.build(), ConverterFunctions.map((String)"names", (Type)new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<RemoteObject> queryObjects(RemoteObjectId prototypeObjectId, Optional<String> objectGroup) {
        Objects.requireNonNull(prototypeObjectId, "prototypeObjectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"prototypeObjectId", (Object)prototypeObjectId);
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        return new Command("Runtime.queryObjects", (Map)params.build(), ConverterFunctions.map((String)"objects", RemoteObject.class));
    }

    public static Command<Void> releaseObject(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        return new Command("Runtime.releaseObject", (Map)params.build());
    }

    public static Command<Void> releaseObjectGroup(String objectGroup) {
        Objects.requireNonNull(objectGroup, "objectGroup is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectGroup", (Object)objectGroup);
        return new Command("Runtime.releaseObjectGroup", (Map)params.build());
    }

    public static Command<Void> runIfWaitingForDebugger() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Runtime.runIfWaitingForDebugger", (Map)params.build());
    }

    public static Command<RunScriptResponse> runScript(ScriptId scriptId, Optional<ExecutionContextId> executionContextId, Optional<String> objectGroup, Optional<Boolean> silent, Optional<Boolean> includeCommandLineAPI, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> awaitPromise) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scriptId", (Object)scriptId);
        executionContextId.ifPresent(p -> params.put((Object)"executionContextId", p));
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        silent.ifPresent(p -> params.put((Object)"silent", p));
        includeCommandLineAPI.ifPresent(p -> params.put((Object)"includeCommandLineAPI", p));
        returnByValue.ifPresent(p -> params.put((Object)"returnByValue", p));
        generatePreview.ifPresent(p -> params.put((Object)"generatePreview", p));
        awaitPromise.ifPresent(p -> params.put((Object)"awaitPromise", p));
        return new Command("Runtime.runScript", (Map)params.build(), input -> (RunScriptResponse)input.read(RunScriptResponse.class));
    }

    public static Command<Void> setAsyncCallStackDepth(Integer maxDepth) {
        Objects.requireNonNull(maxDepth, "maxDepth is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"maxDepth", (Object)maxDepth);
        return new Command("Runtime.setAsyncCallStackDepth", (Map)params.build());
    }

    @Beta
    public static Command<Void> setCustomObjectFormatterEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enabled", (Object)enabled);
        return new Command("Runtime.setCustomObjectFormatterEnabled", (Map)params.build());
    }

    @Beta
    public static Command<Void> setMaxCallStackSizeToCapture(Integer size) {
        Objects.requireNonNull(size, "size is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"size", (Object)size);
        return new Command("Runtime.setMaxCallStackSizeToCapture", (Map)params.build());
    }

    @Beta
    public static Command<Void> terminateExecution() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Runtime.terminateExecution", (Map)params.build());
    }

    @Beta
    public static Command<Void> addBinding(String name, Optional<ExecutionContextId> executionContextId, Optional<String> executionContextName) {
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"name", (Object)name);
        executionContextId.ifPresent(p -> params.put((Object)"executionContextId", p));
        executionContextName.ifPresent(p -> params.put((Object)"executionContextName", p));
        return new Command("Runtime.addBinding", (Map)params.build());
    }

    @Beta
    public static Command<Void> removeBinding(String name) {
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"name", (Object)name);
        return new Command("Runtime.removeBinding", (Map)params.build());
    }

    public static Event<BindingCalled> bindingCalled() {
        return new Event("Runtime.bindingCalled", input -> (BindingCalled)input.read(BindingCalled.class));
    }

    public static Event<ConsoleAPICalled> consoleAPICalled() {
        return new Event("Runtime.consoleAPICalled", input -> (ConsoleAPICalled)input.read(ConsoleAPICalled.class));
    }

    public static Event<ExceptionRevoked> exceptionRevoked() {
        return new Event("Runtime.exceptionRevoked", input -> (ExceptionRevoked)input.read(ExceptionRevoked.class));
    }

    public static Event<ExceptionThrown> exceptionThrown() {
        return new Event("Runtime.exceptionThrown", input -> (ExceptionThrown)input.read(ExceptionThrown.class));
    }

    public static Event<ExecutionContextDescription> executionContextCreated() {
        return new Event("Runtime.executionContextCreated", ConverterFunctions.map((String)"context", ExecutionContextDescription.class));
    }

    public static Event<ExecutionContextId> executionContextDestroyed() {
        return new Event("Runtime.executionContextDestroyed", ConverterFunctions.map((String)"executionContextId", ExecutionContextId.class));
    }

    public static Event<Void> executionContextsCleared() {
        return new Event("Runtime.executionContextsCleared", input -> null);
    }

    public static Event<InspectRequested> inspectRequested() {
        return new Event("Runtime.inspectRequested", input -> (InspectRequested)input.read(InspectRequested.class));
    }

    public static class RunScriptResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public RunScriptResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static RunScriptResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RunScriptResponse(result, exceptionDetails);
        }
    }

    public static class GetPropertiesResponse {
        private final List<PropertyDescriptor> result;
        private final Optional<List<InternalPropertyDescriptor>> internalProperties;
        private final Optional<List<PrivatePropertyDescriptor>> privateProperties;
        private final Optional<ExceptionDetails> exceptionDetails;

        public GetPropertiesResponse(List<PropertyDescriptor> result, Optional<List<InternalPropertyDescriptor>> internalProperties, Optional<List<PrivatePropertyDescriptor>> privateProperties, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.internalProperties = internalProperties;
            this.privateProperties = privateProperties;
            this.exceptionDetails = exceptionDetails;
        }

        public List<PropertyDescriptor> getResult() {
            return this.result;
        }

        public Optional<List<InternalPropertyDescriptor>> getInternalProperties() {
            return this.internalProperties;
        }

        public Optional<List<PrivatePropertyDescriptor>> getPrivateProperties() {
            return this.privateProperties;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static GetPropertiesResponse fromJson(JsonInput input) {
            List result = null;
            Optional<List<InternalPropertyDescriptor>> internalProperties = Optional.empty();
            Optional<List<PrivatePropertyDescriptor>> privateProperties = Optional.empty();
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (List)input.read(new TypeToken<List<PropertyDescriptor>>(){}.getType());
                        continue block12;
                    }
                    case "internalProperties": {
                        internalProperties = Optional.ofNullable((List)input.read(new TypeToken<List<InternalPropertyDescriptor>>(){}.getType()));
                        continue block12;
                    }
                    case "privateProperties": {
                        privateProperties = Optional.ofNullable((List)input.read(new TypeToken<List<PrivatePropertyDescriptor>>(){}.getType()));
                        continue block12;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetPropertiesResponse(result, internalProperties, privateProperties, exceptionDetails);
        }
    }

    public static class GetHeapUsageResponse {
        private final Number usedSize;
        private final Number totalSize;

        public GetHeapUsageResponse(Number usedSize, Number totalSize) {
            this.usedSize = Objects.requireNonNull(usedSize, "usedSize is required");
            this.totalSize = Objects.requireNonNull(totalSize, "totalSize is required");
        }

        public Number getUsedSize() {
            return this.usedSize;
        }

        public Number getTotalSize() {
            return this.totalSize;
        }

        private static GetHeapUsageResponse fromJson(JsonInput input) {
            Number usedSize = 0;
            Number totalSize = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "usedSize": {
                        usedSize = input.nextNumber();
                        continue block8;
                    }
                    case "totalSize": {
                        totalSize = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetHeapUsageResponse(usedSize, totalSize);
        }
    }

    public static class EvaluateResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public EvaluateResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static EvaluateResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new EvaluateResponse(result, exceptionDetails);
        }
    }

    public static class CompileScriptResponse {
        private final Optional<ScriptId> scriptId;
        private final Optional<ExceptionDetails> exceptionDetails;

        public CompileScriptResponse(Optional<ScriptId> scriptId, Optional<ExceptionDetails> exceptionDetails) {
            this.scriptId = scriptId;
            this.exceptionDetails = exceptionDetails;
        }

        public Optional<ScriptId> getScriptId() {
            return this.scriptId;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static CompileScriptResponse fromJson(JsonInput input) {
            Optional<ScriptId> scriptId = Optional.empty();
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "scriptId": {
                        scriptId = Optional.ofNullable((ScriptId)input.read(ScriptId.class));
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CompileScriptResponse(scriptId, exceptionDetails);
        }
    }

    public static class CallFunctionOnResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public CallFunctionOnResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static CallFunctionOnResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CallFunctionOnResponse(result, exceptionDetails);
        }
    }

    public static class AwaitPromiseResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public AwaitPromiseResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static AwaitPromiseResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new AwaitPromiseResponse(result, exceptionDetails);
        }
    }
}

