/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v93.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v93.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v93.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class LoadingFinished {
    private final RequestId requestId;
    private final MonotonicTime timestamp;
    private final Number encodedDataLength;
    private final Optional<Boolean> shouldReportCorbBlocking;

    public LoadingFinished(RequestId requestId, MonotonicTime timestamp, Number encodedDataLength, Optional<Boolean> shouldReportCorbBlocking) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.encodedDataLength = Objects.requireNonNull(encodedDataLength, "encodedDataLength is required");
        this.shouldReportCorbBlocking = shouldReportCorbBlocking;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public Number getEncodedDataLength() {
        return this.encodedDataLength;
    }

    public Optional<Boolean> getShouldReportCorbBlocking() {
        return this.shouldReportCorbBlocking;
    }

    private static LoadingFinished fromJson(JsonInput input) {
        RequestId requestId = null;
        MonotonicTime timestamp = null;
        Number encodedDataLength = 0;
        Optional<Boolean> shouldReportCorbBlocking = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block12;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block12;
                }
                case "encodedDataLength": {
                    encodedDataLength = input.nextNumber();
                    continue block12;
                }
                case "shouldReportCorbBlocking": {
                    shouldReportCorbBlocking = Optional.ofNullable(input.nextBoolean());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LoadingFinished(requestId, timestamp, encodedDataLength, shouldReportCorbBlocking);
    }
}

