/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v93.debugger.model;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v93.debugger.model.ScriptLanguage;
import org.openqa.selenium.devtools.v93.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.v93.runtime.model.ScriptId;
import org.openqa.selenium.devtools.v93.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class ScriptFailedToParse {
    private final ScriptId scriptId;
    private final String url;
    private final Integer startLine;
    private final Integer startColumn;
    private final Integer endLine;
    private final Integer endColumn;
    private final ExecutionContextId executionContextId;
    private final String hash;
    private final Optional<Map<String, Object>> executionContextAuxData;
    private final Optional<String> sourceMapURL;
    private final Optional<Boolean> hasSourceURL;
    private final Optional<Boolean> isModule;
    private final Optional<Integer> length;
    private final Optional<StackTrace> stackTrace;
    private final Optional<Integer> codeOffset;
    private final Optional<ScriptLanguage> scriptLanguage;
    private final Optional<String> embedderName;

    public ScriptFailedToParse(ScriptId scriptId, String url, Integer startLine, Integer startColumn, Integer endLine, Integer endColumn, ExecutionContextId executionContextId, String hash, Optional<Map<String, Object>> executionContextAuxData, Optional<String> sourceMapURL, Optional<Boolean> hasSourceURL, Optional<Boolean> isModule, Optional<Integer> length, Optional<StackTrace> stackTrace, Optional<Integer> codeOffset, Optional<ScriptLanguage> scriptLanguage, Optional<String> embedderName) {
        this.scriptId = Objects.requireNonNull(scriptId, "scriptId is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.startLine = Objects.requireNonNull(startLine, "startLine is required");
        this.startColumn = Objects.requireNonNull(startColumn, "startColumn is required");
        this.endLine = Objects.requireNonNull(endLine, "endLine is required");
        this.endColumn = Objects.requireNonNull(endColumn, "endColumn is required");
        this.executionContextId = Objects.requireNonNull(executionContextId, "executionContextId is required");
        this.hash = Objects.requireNonNull(hash, "hash is required");
        this.executionContextAuxData = executionContextAuxData;
        this.sourceMapURL = sourceMapURL;
        this.hasSourceURL = hasSourceURL;
        this.isModule = isModule;
        this.length = length;
        this.stackTrace = stackTrace;
        this.codeOffset = codeOffset;
        this.scriptLanguage = scriptLanguage;
        this.embedderName = embedderName;
    }

    public ScriptId getScriptId() {
        return this.scriptId;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getStartLine() {
        return this.startLine;
    }

    public Integer getStartColumn() {
        return this.startColumn;
    }

    public Integer getEndLine() {
        return this.endLine;
    }

    public Integer getEndColumn() {
        return this.endColumn;
    }

    public ExecutionContextId getExecutionContextId() {
        return this.executionContextId;
    }

    public String getHash() {
        return this.hash;
    }

    public Optional<Map<String, Object>> getExecutionContextAuxData() {
        return this.executionContextAuxData;
    }

    public Optional<String> getSourceMapURL() {
        return this.sourceMapURL;
    }

    public Optional<Boolean> getHasSourceURL() {
        return this.hasSourceURL;
    }

    public Optional<Boolean> getIsModule() {
        return this.isModule;
    }

    public Optional<Integer> getLength() {
        return this.length;
    }

    @Beta
    public Optional<StackTrace> getStackTrace() {
        return this.stackTrace;
    }

    @Beta
    public Optional<Integer> getCodeOffset() {
        return this.codeOffset;
    }

    @Beta
    public Optional<ScriptLanguage> getScriptLanguage() {
        return this.scriptLanguage;
    }

    @Beta
    public Optional<String> getEmbedderName() {
        return this.embedderName;
    }

    private static ScriptFailedToParse fromJson(JsonInput input) {
        ScriptId scriptId = null;
        String url = null;
        Integer startLine = 0;
        Integer startColumn = 0;
        Integer endLine = 0;
        Integer endColumn = 0;
        ExecutionContextId executionContextId = null;
        String hash = null;
        Optional<Map<String, Object>> executionContextAuxData = Optional.empty();
        Optional<String> sourceMapURL = Optional.empty();
        Optional<Boolean> hasSourceURL = Optional.empty();
        Optional<Boolean> isModule = Optional.empty();
        Optional<Integer> length = Optional.empty();
        Optional<StackTrace> stackTrace = Optional.empty();
        Optional<Integer> codeOffset = Optional.empty();
        Optional<ScriptLanguage> scriptLanguage = Optional.empty();
        Optional<String> embedderName = Optional.empty();
        input.beginObject();
        block38: while (input.hasNext()) {
            switch (input.nextName()) {
                case "scriptId": {
                    scriptId = (ScriptId)input.read(ScriptId.class);
                    continue block38;
                }
                case "url": {
                    url = input.nextString();
                    continue block38;
                }
                case "startLine": {
                    startLine = input.nextNumber().intValue();
                    continue block38;
                }
                case "startColumn": {
                    startColumn = input.nextNumber().intValue();
                    continue block38;
                }
                case "endLine": {
                    endLine = input.nextNumber().intValue();
                    continue block38;
                }
                case "endColumn": {
                    endColumn = input.nextNumber().intValue();
                    continue block38;
                }
                case "executionContextId": {
                    executionContextId = (ExecutionContextId)input.read(ExecutionContextId.class);
                    continue block38;
                }
                case "hash": {
                    hash = input.nextString();
                    continue block38;
                }
                case "executionContextAuxData": {
                    executionContextAuxData = Optional.ofNullable((Map)input.read(new TypeToken<Map<String, Object>>(){}.getType()));
                    continue block38;
                }
                case "sourceMapURL": {
                    sourceMapURL = Optional.ofNullable(input.nextString());
                    continue block38;
                }
                case "hasSourceURL": {
                    hasSourceURL = Optional.ofNullable(input.nextBoolean());
                    continue block38;
                }
                case "isModule": {
                    isModule = Optional.ofNullable(input.nextBoolean());
                    continue block38;
                }
                case "length": {
                    length = Optional.ofNullable(input.nextNumber().intValue());
                    continue block38;
                }
                case "stackTrace": {
                    stackTrace = Optional.ofNullable((StackTrace)input.read(StackTrace.class));
                    continue block38;
                }
                case "codeOffset": {
                    codeOffset = Optional.ofNullable(input.nextNumber().intValue());
                    continue block38;
                }
                case "scriptLanguage": {
                    scriptLanguage = Optional.ofNullable((ScriptLanguage)((Object)input.read(ScriptLanguage.class)));
                    continue block38;
                }
                case "embedderName": {
                    embedderName = Optional.ofNullable(input.nextString());
                    continue block38;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScriptFailedToParse(scriptId, url, startLine, startColumn, endLine, endColumn, executionContextId, hash, executionContextAuxData, sourceMapURL, hasSourceURL, isModule, length, stackTrace, codeOffset, scriptLanguage, embedderName);
    }
}

