package org.openqa.selenium.devtools.v91.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class InstallabilityErrorArgument {

    private final java.lang.String name;

    private final java.lang.String value;

    public InstallabilityErrorArgument(java.lang.String name, java.lang.String value) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.value = java.util.Objects.requireNonNull(value, "value is required");
    }

    /**
     * Argument name (e.g. name:'minimum-icon-size-in-pixels').
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * Argument value (e.g. value:'64').
     */
    public java.lang.String getValue() {
        return value;
    }

    private static InstallabilityErrorArgument fromJson(JsonInput input) {
        java.lang.String name = null;
        java.lang.String value = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "value":
                    value = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new InstallabilityErrorArgument(name, value);
    }
}
