package org.openqa.selenium.devtools.v91.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when additional information about a responseReceived event is available from the network
 * stack. Not every responseReceived event will have an additional responseReceivedExtraInfo for
 * it, and responseReceivedExtraInfo may be fired before or after responseReceived.
 */
@org.openqa.selenium.Beta()
public class ResponseReceivedExtraInfo {

    private final org.openqa.selenium.devtools.v91.network.model.RequestId requestId;

    private final java.util.List<org.openqa.selenium.devtools.v91.network.model.BlockedSetCookieWithReason> blockedCookies;

    private final org.openqa.selenium.devtools.v91.network.model.Headers headers;

    private final org.openqa.selenium.devtools.v91.network.model.IPAddressSpace resourceIPAddressSpace;

    private final java.util.Optional<java.lang.String> headersText;

    public ResponseReceivedExtraInfo(org.openqa.selenium.devtools.v91.network.model.RequestId requestId, java.util.List<org.openqa.selenium.devtools.v91.network.model.BlockedSetCookieWithReason> blockedCookies, org.openqa.selenium.devtools.v91.network.model.Headers headers, org.openqa.selenium.devtools.v91.network.model.IPAddressSpace resourceIPAddressSpace, java.util.Optional<java.lang.String> headersText) {
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.blockedCookies = java.util.Objects.requireNonNull(blockedCookies, "blockedCookies is required");
        this.headers = java.util.Objects.requireNonNull(headers, "headers is required");
        this.resourceIPAddressSpace = java.util.Objects.requireNonNull(resourceIPAddressSpace, "resourceIPAddressSpace is required");
        this.headersText = headersText;
    }

    /**
     * Request identifier. Used to match this information to another responseReceived event.
     */
    public org.openqa.selenium.devtools.v91.network.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * A list of cookies which were not stored from the response along with the corresponding
     * reasons for blocking. The cookies here may not be valid due to syntax errors, which
     * are represented by the invalid cookie line string instead of a proper cookie.
     */
    public java.util.List<org.openqa.selenium.devtools.v91.network.model.BlockedSetCookieWithReason> getBlockedCookies() {
        return blockedCookies;
    }

    /**
     * Raw response headers as they were received over the wire.
     */
    public org.openqa.selenium.devtools.v91.network.model.Headers getHeaders() {
        return headers;
    }

    /**
     * The IP address space of the resource. The address space can only be determined once the transport
     * established the connection, so we can't send it in `requestWillBeSentExtraInfo`.
     */
    public org.openqa.selenium.devtools.v91.network.model.IPAddressSpace getResourceIPAddressSpace() {
        return resourceIPAddressSpace;
    }

    /**
     * Raw response header text as it was received over the wire. The raw text may not always be
     * available, such as in the case of HTTP/2 or QUIC.
     */
    public java.util.Optional<java.lang.String> getHeadersText() {
        return headersText;
    }

    private static ResponseReceivedExtraInfo fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v91.network.model.RequestId requestId = null;
        java.util.List<org.openqa.selenium.devtools.v91.network.model.BlockedSetCookieWithReason> blockedCookies = null;
        org.openqa.selenium.devtools.v91.network.model.Headers headers = null;
        org.openqa.selenium.devtools.v91.network.model.IPAddressSpace resourceIPAddressSpace = null;
        java.util.Optional<java.lang.String> headersText = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v91.network.model.RequestId.class);
                    break;
                case "blockedCookies":
                    blockedCookies = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v91.network.model.BlockedSetCookieWithReason>>() {
                    }.getType());
                    break;
                case "headers":
                    headers = input.read(org.openqa.selenium.devtools.v91.network.model.Headers.class);
                    break;
                case "resourceIPAddressSpace":
                    resourceIPAddressSpace = input.read(org.openqa.selenium.devtools.v91.network.model.IPAddressSpace.class);
                    break;
                case "headersText":
                    headersText = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ResponseReceivedExtraInfo(requestId, blockedCookies, headers, resourceIPAddressSpace, headersText);
    }
}
