package org.openqa.selenium.devtools.v91.indexeddb.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Key range.
 */
public class KeyRange {

    private final java.util.Optional<org.openqa.selenium.devtools.v91.indexeddb.model.Key> lower;

    private final java.util.Optional<org.openqa.selenium.devtools.v91.indexeddb.model.Key> upper;

    private final java.lang.Boolean lowerOpen;

    private final java.lang.Boolean upperOpen;

    public KeyRange(java.util.Optional<org.openqa.selenium.devtools.v91.indexeddb.model.Key> lower, java.util.Optional<org.openqa.selenium.devtools.v91.indexeddb.model.Key> upper, java.lang.Boolean lowerOpen, java.lang.Boolean upperOpen) {
        this.lower = lower;
        this.upper = upper;
        this.lowerOpen = java.util.Objects.requireNonNull(lowerOpen, "lowerOpen is required");
        this.upperOpen = java.util.Objects.requireNonNull(upperOpen, "upperOpen is required");
    }

    /**
     * Lower bound.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v91.indexeddb.model.Key> getLower() {
        return lower;
    }

    /**
     * Upper bound.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v91.indexeddb.model.Key> getUpper() {
        return upper;
    }

    /**
     * If true lower bound is open.
     */
    public java.lang.Boolean getLowerOpen() {
        return lowerOpen;
    }

    /**
     * If true upper bound is open.
     */
    public java.lang.Boolean getUpperOpen() {
        return upperOpen;
    }

    private static KeyRange fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v91.indexeddb.model.Key> lower = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v91.indexeddb.model.Key> upper = java.util.Optional.empty();
        java.lang.Boolean lowerOpen = false;
        java.lang.Boolean upperOpen = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "lower":
                    lower = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v91.indexeddb.model.Key.class));
                    break;
                case "upper":
                    upper = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v91.indexeddb.model.Key.class));
                    break;
                case "lowerOpen":
                    lowerOpen = input.nextBoolean();
                    break;
                case "upperOpen":
                    upperOpen = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new KeyRange(lower, upper, lowerOpen, upperOpen);
    }
}
