/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v91.animation.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v91.animation.model.KeyframesRule;
import org.openqa.selenium.devtools.v91.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class AnimationEffect {
    private final Number delay;
    private final Number endDelay;
    private final Number iterationStart;
    private final Number iterations;
    private final Number duration;
    private final String direction;
    private final String fill;
    private final Optional<BackendNodeId> backendNodeId;
    private final Optional<KeyframesRule> keyframesRule;
    private final String easing;

    public AnimationEffect(Number delay, Number endDelay, Number iterationStart, Number iterations, Number duration, String direction, String fill, Optional<BackendNodeId> backendNodeId, Optional<KeyframesRule> keyframesRule, String easing) {
        this.delay = Objects.requireNonNull(delay, "delay is required");
        this.endDelay = Objects.requireNonNull(endDelay, "endDelay is required");
        this.iterationStart = Objects.requireNonNull(iterationStart, "iterationStart is required");
        this.iterations = Objects.requireNonNull(iterations, "iterations is required");
        this.duration = Objects.requireNonNull(duration, "duration is required");
        this.direction = Objects.requireNonNull(direction, "direction is required");
        this.fill = Objects.requireNonNull(fill, "fill is required");
        this.backendNodeId = backendNodeId;
        this.keyframesRule = keyframesRule;
        this.easing = Objects.requireNonNull(easing, "easing is required");
    }

    public Number getDelay() {
        return this.delay;
    }

    public Number getEndDelay() {
        return this.endDelay;
    }

    public Number getIterationStart() {
        return this.iterationStart;
    }

    public Number getIterations() {
        return this.iterations;
    }

    public Number getDuration() {
        return this.duration;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getFill() {
        return this.fill;
    }

    public Optional<BackendNodeId> getBackendNodeId() {
        return this.backendNodeId;
    }

    public Optional<KeyframesRule> getKeyframesRule() {
        return this.keyframesRule;
    }

    public String getEasing() {
        return this.easing;
    }

    private static AnimationEffect fromJson(JsonInput input) {
        Number delay = 0;
        Number endDelay = 0;
        Number iterationStart = 0;
        Number iterations = 0;
        Number duration = 0;
        String direction = null;
        String fill = null;
        Optional<BackendNodeId> backendNodeId = Optional.empty();
        Optional<KeyframesRule> keyframesRule = Optional.empty();
        String easing = null;
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "delay": {
                    delay = input.nextNumber();
                    continue block24;
                }
                case "endDelay": {
                    endDelay = input.nextNumber();
                    continue block24;
                }
                case "iterationStart": {
                    iterationStart = input.nextNumber();
                    continue block24;
                }
                case "iterations": {
                    iterations = input.nextNumber();
                    continue block24;
                }
                case "duration": {
                    duration = input.nextNumber();
                    continue block24;
                }
                case "direction": {
                    direction = input.nextString();
                    continue block24;
                }
                case "fill": {
                    fill = input.nextString();
                    continue block24;
                }
                case "backendNodeId": {
                    backendNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block24;
                }
                case "keyframesRule": {
                    keyframesRule = Optional.ofNullable((KeyframesRule)input.read(KeyframesRule.class));
                    continue block24;
                }
                case "easing": {
                    easing = input.nextString();
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AnimationEffect(delay, endDelay, iterationStart, iterations, duration, direction, fill, backendNodeId, keyframesRule, easing);
    }
}

