package org.openqa.selenium.devtools.v90.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class PermissionsPolicyBlockLocator {

    private final org.openqa.selenium.devtools.v90.page.model.FrameId frameId;

    private final org.openqa.selenium.devtools.v90.page.model.PermissionsPolicyBlockReason blockReason;

    public PermissionsPolicyBlockLocator(org.openqa.selenium.devtools.v90.page.model.FrameId frameId, org.openqa.selenium.devtools.v90.page.model.PermissionsPolicyBlockReason blockReason) {
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.blockReason = java.util.Objects.requireNonNull(blockReason, "blockReason is required");
    }

    public org.openqa.selenium.devtools.v90.page.model.FrameId getFrameId() {
        return frameId;
    }

    public org.openqa.selenium.devtools.v90.page.model.PermissionsPolicyBlockReason getBlockReason() {
        return blockReason;
    }

    private static PermissionsPolicyBlockLocator fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v90.page.model.FrameId frameId = null;
        org.openqa.selenium.devtools.v90.page.model.PermissionsPolicyBlockReason blockReason = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v90.page.model.FrameId.class);
                    break;
                case "blockReason":
                    blockReason = input.read(org.openqa.selenium.devtools.v90.page.model.PermissionsPolicyBlockReason.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PermissionsPolicyBlockLocator(frameId, blockReason);
    }
}
