package org.openqa.selenium.devtools.v90.debugger.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when the virtual machine stopped on breakpoint or exception or any other stop criteria.
 */
public class Paused {

    public enum Reason {

        AMBIGUOUS("ambiguous"),
        ASSERT("assert"),
        CSPVIOLATION("CSPViolation"),
        DEBUGCOMMAND("debugCommand"),
        DOM("DOM"),
        EVENTLISTENER("EventListener"),
        EXCEPTION("exception"),
        INSTRUMENTATION("instrumentation"),
        OOM("OOM"),
        OTHER("other"),
        PROMISEREJECTION("promiseRejection"),
        XHR("XHR");

        private String value;

        Reason(String value) {
            this.value = value;
        }

        public static Reason fromString(String s) {
            return java.util.Arrays.stream(Reason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Reason "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Reason fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final java.util.List<org.openqa.selenium.devtools.v90.debugger.model.CallFrame> callFrames;

    private final Reason reason;

    private final java.util.Optional<java.util.Map<String, Object>> data;

    private final java.util.Optional<java.util.List<java.lang.String>> hitBreakpoints;

    private final java.util.Optional<org.openqa.selenium.devtools.v90.runtime.model.StackTrace> asyncStackTrace;

    private final java.util.Optional<org.openqa.selenium.devtools.v90.runtime.model.StackTraceId> asyncStackTraceId;

    private final java.util.Optional<org.openqa.selenium.devtools.v90.runtime.model.StackTraceId> asyncCallStackTraceId;

    public Paused(java.util.List<org.openqa.selenium.devtools.v90.debugger.model.CallFrame> callFrames, Reason reason, java.util.Optional<java.util.Map<String, Object>> data, java.util.Optional<java.util.List<java.lang.String>> hitBreakpoints, java.util.Optional<org.openqa.selenium.devtools.v90.runtime.model.StackTrace> asyncStackTrace, java.util.Optional<org.openqa.selenium.devtools.v90.runtime.model.StackTraceId> asyncStackTraceId, java.util.Optional<org.openqa.selenium.devtools.v90.runtime.model.StackTraceId> asyncCallStackTraceId) {
        this.callFrames = java.util.Objects.requireNonNull(callFrames, "callFrames is required");
        this.reason = java.util.Objects.requireNonNull(reason, "reason is required");
        this.data = data;
        this.hitBreakpoints = hitBreakpoints;
        this.asyncStackTrace = asyncStackTrace;
        this.asyncStackTraceId = asyncStackTraceId;
        this.asyncCallStackTraceId = asyncCallStackTraceId;
    }

    /**
     * Call stack the virtual machine stopped on.
     */
    public java.util.List<org.openqa.selenium.devtools.v90.debugger.model.CallFrame> getCallFrames() {
        return callFrames;
    }

    /**
     * Pause reason.
     */
    public Reason getReason() {
        return reason;
    }

    /**
     * Object containing break-specific auxiliary properties.
     */
    public java.util.Optional<java.util.Map<String, Object>> getData() {
        return data;
    }

    /**
     * Hit breakpoints IDs
     */
    public java.util.Optional<java.util.List<java.lang.String>> getHitBreakpoints() {
        return hitBreakpoints;
    }

    /**
     * Async stack trace, if any.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v90.runtime.model.StackTrace> getAsyncStackTrace() {
        return asyncStackTrace;
    }

    /**
     * Async stack trace, if any.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v90.runtime.model.StackTraceId> getAsyncStackTraceId() {
        return asyncStackTraceId;
    }

    /**
     * Never present, will be removed.
     */
    @Beta()
    @Deprecated()
    public java.util.Optional<org.openqa.selenium.devtools.v90.runtime.model.StackTraceId> getAsyncCallStackTraceId() {
        return asyncCallStackTraceId;
    }

    private static Paused fromJson(JsonInput input) {
        java.util.List<org.openqa.selenium.devtools.v90.debugger.model.CallFrame> callFrames = null;
        Reason reason = null;
        java.util.Optional<java.util.Map<String, Object>> data = java.util.Optional.empty();
        java.util.Optional<java.util.List<java.lang.String>> hitBreakpoints = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v90.runtime.model.StackTrace> asyncStackTrace = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v90.runtime.model.StackTraceId> asyncStackTraceId = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v90.runtime.model.StackTraceId> asyncCallStackTraceId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "callFrames":
                    callFrames = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v90.debugger.model.CallFrame>>() {
                    }.getType());
                    break;
                case "reason":
                    reason = Reason.fromString(input.nextString());
                    break;
                case "data":
                    data = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.Map<String, Object>>() {
                    }.getType()));
                    break;
                case "hitBreakpoints":
                    hitBreakpoints = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<java.lang.String>>() {
                    }.getType()));
                    break;
                case "asyncStackTrace":
                    asyncStackTrace = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v90.runtime.model.StackTrace.class));
                    break;
                case "asyncStackTraceId":
                    asyncStackTraceId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v90.runtime.model.StackTraceId.class));
                    break;
                case "asyncCallStackTraceId":
                    asyncCallStackTraceId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v90.runtime.model.StackTraceId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Paused(callFrames, reason, data, hitBreakpoints, asyncStackTrace, asyncStackTraceId, asyncCallStackTraceId);
    }
}
