/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.systeminfo.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum SubsamplingFormat {
    YUV420("yuv420"),
    YUV422("yuv422"),
    YUV444("yuv444");

    private String value;

    private SubsamplingFormat(String value) {
        this.value = value;
    }

    public static SubsamplingFormat fromString(String s) {
        return Arrays.stream(SubsamplingFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SubsamplingFormat "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static SubsamplingFormat fromJson(JsonInput input) {
        return SubsamplingFormat.fromString(input.nextString());
    }
}

