/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v89.audits.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class SourceCodeLocation {
    private final String url;
    private final Integer lineNumber;
    private final Integer columnNumber;

    public SourceCodeLocation(String url, Integer lineNumber, Integer columnNumber) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = Objects.requireNonNull(columnNumber, "columnNumber is required");
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    private static SourceCodeLocation fromJson(JsonInput input) {
        String url = null;
        Integer lineNumber = 0;
        Integer columnNumber = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block10;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block10;
                }
                case "columnNumber": {
                    columnNumber = input.nextNumber().intValue();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SourceCodeLocation(url, lineNumber, columnNumber);
    }
}

