/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v89.profiler.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class RuntimeCallCounterInfo {
    private final String name;
    private final Number value;
    private final Number time;

    public RuntimeCallCounterInfo(String name, Number value, Number time) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
        this.time = Objects.requireNonNull(time, "time is required");
    }

    public String getName() {
        return this.name;
    }

    public Number getValue() {
        return this.value;
    }

    public Number getTime() {
        return this.time;
    }

    private static RuntimeCallCounterInfo fromJson(JsonInput input) {
        String name = null;
        Number value = 0;
        Number time = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block10;
                }
                case "value": {
                    value = input.nextNumber();
                    continue block10;
                }
                case "time": {
                    time = input.nextNumber();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RuntimeCallCounterInfo(name, value, time);
    }
}

