package org.openqa.selenium.devtools.v88.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum SameSiteCookieWarningReason {

    WARNSAMESITEUNSPECIFIEDCROSSSITECONTEXT("WarnSameSiteUnspecifiedCrossSiteContext"),
    WARNSAMESITENONEINSECURE("WarnSameSiteNoneInsecure"),
    WARNSAMESITEUNSPECIFIEDLAXALLOWUNSAFE("WarnSameSiteUnspecifiedLaxAllowUnsafe"),
    WARNSAMESITESTRICTLAXDOWNGRADESTRICT("WarnSameSiteStrictLaxDowngradeStrict"),
    WARNSAMESITESTRICTCROSSDOWNGRADESTRICT("WarnSameSiteStrictCrossDowngradeStrict"),
    WARNSAMESITESTRICTCROSSDOWNGRADELAX("WarnSameSiteStrictCrossDowngradeLax"),
    WARNSAMESITELAXCROSSDOWNGRADESTRICT("WarnSameSiteLaxCrossDowngradeStrict"),
    WARNSAMESITELAXCROSSDOWNGRADELAX("WarnSameSiteLaxCrossDowngradeLax");

    private String value;

    SameSiteCookieWarningReason(String value) {
        this.value = value;
    }

    public static SameSiteCookieWarningReason fromString(String s) {
        return java.util.Arrays.stream(SameSiteCookieWarningReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SameSiteCookieWarningReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static SameSiteCookieWarningReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
