package org.openqa.selenium.devtools.v88.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum SameSiteCookieOperation {

    SETCOOKIE("SetCookie"), READCOOKIE("ReadCookie");

    private String value;

    SameSiteCookieOperation(String value) {
        this.value = value;
    }

    public static SameSiteCookieOperation fromString(String s) {
        return java.util.Arrays.stream(SameSiteCookieOperation.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SameSiteCookieOperation "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static SameSiteCookieOperation fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
