/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v87.domdebugger.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum DOMBreakpointType {
    SUBTREE_MODIFIED("subtree-modified"),
    ATTRIBUTE_MODIFIED("attribute-modified"),
    NODE_REMOVED("node-removed");

    private String value;

    private DOMBreakpointType(String value) {
        this.value = value;
    }

    public static DOMBreakpointType fromString(String s) {
        return Arrays.stream(DOMBreakpointType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within DOMBreakpointType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static DOMBreakpointType fromJson(JsonInput input) {
        return DOMBreakpointType.fromString(input.nextString());
    }
}

