package org.openqa.selenium.devtools.v87.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Used to specify User Agent Cient Hints to emulate. See https://wicg.github.io/ua-client-hints
 */
@org.openqa.selenium.Beta()
public class UserAgentMetadata {

    private final java.util.List<org.openqa.selenium.devtools.v87.emulation.model.UserAgentBrandVersion> brands;

    private final java.lang.String fullVersion;

    private final java.lang.String platform;

    private final java.lang.String platformVersion;

    private final java.lang.String architecture;

    private final java.lang.String model;

    private final java.lang.Boolean mobile;

    public UserAgentMetadata(java.util.List<org.openqa.selenium.devtools.v87.emulation.model.UserAgentBrandVersion> brands, java.lang.String fullVersion, java.lang.String platform, java.lang.String platformVersion, java.lang.String architecture, java.lang.String model, java.lang.Boolean mobile) {
        this.brands = java.util.Objects.requireNonNull(brands, "brands is required");
        this.fullVersion = java.util.Objects.requireNonNull(fullVersion, "fullVersion is required");
        this.platform = java.util.Objects.requireNonNull(platform, "platform is required");
        this.platformVersion = java.util.Objects.requireNonNull(platformVersion, "platformVersion is required");
        this.architecture = java.util.Objects.requireNonNull(architecture, "architecture is required");
        this.model = java.util.Objects.requireNonNull(model, "model is required");
        this.mobile = java.util.Objects.requireNonNull(mobile, "mobile is required");
    }

    public java.util.List<org.openqa.selenium.devtools.v87.emulation.model.UserAgentBrandVersion> getBrands() {
        return brands;
    }

    public java.lang.String getFullVersion() {
        return fullVersion;
    }

    public java.lang.String getPlatform() {
        return platform;
    }

    public java.lang.String getPlatformVersion() {
        return platformVersion;
    }

    public java.lang.String getArchitecture() {
        return architecture;
    }

    public java.lang.String getModel() {
        return model;
    }

    public java.lang.Boolean getMobile() {
        return mobile;
    }

    private static UserAgentMetadata fromJson(JsonInput input) {
        java.util.List<org.openqa.selenium.devtools.v87.emulation.model.UserAgentBrandVersion> brands = null;
        java.lang.String fullVersion = null;
        java.lang.String platform = null;
        java.lang.String platformVersion = null;
        java.lang.String architecture = null;
        java.lang.String model = null;
        java.lang.Boolean mobile = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "brands":
                    brands = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v87.emulation.model.UserAgentBrandVersion>>() {
                    }.getType());
                    break;
                case "fullVersion":
                    fullVersion = input.nextString();
                    break;
                case "platform":
                    platform = input.nextString();
                    break;
                case "platformVersion":
                    platformVersion = input.nextString();
                    break;
                case "architecture":
                    architecture = input.nextString();
                    break;
                case "model":
                    model = input.nextString();
                    break;
                case "mobile":
                    mobile = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new UserAgentMetadata(brands, fullVersion, platform, platformVersion, architecture, model, mobile);
    }
}
