/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v86.page.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v86.network.model.LoaderId;
import org.openqa.selenium.devtools.v86.page.model.AdFrameType;
import org.openqa.selenium.devtools.v86.page.model.CrossOriginIsolatedContextType;
import org.openqa.selenium.devtools.v86.page.model.FrameId;
import org.openqa.selenium.devtools.v86.page.model.SecureContextType;
import org.openqa.selenium.json.JsonInput;

public class Frame {
    private final FrameId id;
    private final Optional<String> parentId;
    private final LoaderId loaderId;
    private final Optional<String> name;
    private final String url;
    private final Optional<String> urlFragment;
    private final String domainAndRegistry;
    private final String securityOrigin;
    private final String mimeType;
    private final Optional<String> unreachableUrl;
    private final Optional<AdFrameType> adFrameType;
    private final SecureContextType secureContextType;
    private final CrossOriginIsolatedContextType crossOriginIsolatedContextType;

    public Frame(FrameId id, Optional<String> parentId, LoaderId loaderId, Optional<String> name, String url, Optional<String> urlFragment, String domainAndRegistry, String securityOrigin, String mimeType, Optional<String> unreachableUrl, Optional<AdFrameType> adFrameType, SecureContextType secureContextType, CrossOriginIsolatedContextType crossOriginIsolatedContextType) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.parentId = parentId;
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.name = name;
        this.url = Objects.requireNonNull(url, "url is required");
        this.urlFragment = urlFragment;
        this.domainAndRegistry = Objects.requireNonNull(domainAndRegistry, "domainAndRegistry is required");
        this.securityOrigin = Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType is required");
        this.unreachableUrl = unreachableUrl;
        this.adFrameType = adFrameType;
        this.secureContextType = Objects.requireNonNull(secureContextType, "secureContextType is required");
        this.crossOriginIsolatedContextType = Objects.requireNonNull(crossOriginIsolatedContextType, "crossOriginIsolatedContextType is required");
    }

    public FrameId getId() {
        return this.id;
    }

    public Optional<String> getParentId() {
        return this.parentId;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    @Beta
    public Optional<String> getUrlFragment() {
        return this.urlFragment;
    }

    @Beta
    public String getDomainAndRegistry() {
        return this.domainAndRegistry;
    }

    public String getSecurityOrigin() {
        return this.securityOrigin;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Beta
    public Optional<String> getUnreachableUrl() {
        return this.unreachableUrl;
    }

    @Beta
    public Optional<AdFrameType> getAdFrameType() {
        return this.adFrameType;
    }

    @Beta
    public SecureContextType getSecureContextType() {
        return this.secureContextType;
    }

    @Beta
    public CrossOriginIsolatedContextType getCrossOriginIsolatedContextType() {
        return this.crossOriginIsolatedContextType;
    }

    private static Frame fromJson(JsonInput input) {
        FrameId id = null;
        Optional<String> parentId = Optional.empty();
        LoaderId loaderId = null;
        Optional<String> name = Optional.empty();
        String url = null;
        Optional<String> urlFragment = Optional.empty();
        String domainAndRegistry = null;
        String securityOrigin = null;
        String mimeType = null;
        Optional<String> unreachableUrl = Optional.empty();
        Optional<AdFrameType> adFrameType = Optional.empty();
        SecureContextType secureContextType = null;
        CrossOriginIsolatedContextType crossOriginIsolatedContextType = null;
        input.beginObject();
        block30: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (FrameId)input.read(FrameId.class);
                    continue block30;
                }
                case "parentId": {
                    parentId = Optional.ofNullable(input.nextString());
                    continue block30;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read(LoaderId.class);
                    continue block30;
                }
                case "name": {
                    name = Optional.ofNullable(input.nextString());
                    continue block30;
                }
                case "url": {
                    url = input.nextString();
                    continue block30;
                }
                case "urlFragment": {
                    urlFragment = Optional.ofNullable(input.nextString());
                    continue block30;
                }
                case "domainAndRegistry": {
                    domainAndRegistry = input.nextString();
                    continue block30;
                }
                case "securityOrigin": {
                    securityOrigin = input.nextString();
                    continue block30;
                }
                case "mimeType": {
                    mimeType = input.nextString();
                    continue block30;
                }
                case "unreachableUrl": {
                    unreachableUrl = Optional.ofNullable(input.nextString());
                    continue block30;
                }
                case "adFrameType": {
                    adFrameType = Optional.ofNullable((AdFrameType)((Object)input.read(AdFrameType.class)));
                    continue block30;
                }
                case "secureContextType": {
                    secureContextType = (SecureContextType)((Object)input.read(SecureContextType.class));
                    continue block30;
                }
                case "crossOriginIsolatedContextType": {
                    crossOriginIsolatedContextType = (CrossOriginIsolatedContextType)((Object)input.read(CrossOriginIsolatedContextType.class));
                    continue block30;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Frame(id, parentId, loaderId, name, url, urlFragment, domainAndRegistry, securityOrigin, mimeType, unreachableUrl, adFrameType, secureContextType, crossOriginIsolatedContextType);
    }
}

