package org.openqa.selenium.devtools.v86.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information about the frame affected by an inspector issue.
 */
public class AffectedFrame {

    private final org.openqa.selenium.devtools.v86.page.model.FrameId frameId;

    public AffectedFrame(org.openqa.selenium.devtools.v86.page.model.FrameId frameId) {
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
    }

    public org.openqa.selenium.devtools.v86.page.model.FrameId getFrameId() {
        return frameId;
    }

    private static AffectedFrame fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v86.page.model.FrameId frameId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v86.page.model.FrameId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AffectedFrame(frameId);
    }
}
