package org.openqa.selenium.devtools.v84.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when additional information about a requestWillBeSent event is available from the
 * network stack. Not every requestWillBeSent event will have an additional
 * requestWillBeSentExtraInfo fired for it, and there is no guarantee whether requestWillBeSent
 * or requestWillBeSentExtraInfo will be fired first for the same request.
 */
@org.openqa.selenium.Beta()
public class RequestWillBeSentExtraInfo {

    private final org.openqa.selenium.devtools.v84.network.model.RequestId requestId;

    private final java.util.List<org.openqa.selenium.devtools.v84.network.model.BlockedCookieWithReason> associatedCookies;

    private final org.openqa.selenium.devtools.v84.network.model.Headers headers;

    public RequestWillBeSentExtraInfo(org.openqa.selenium.devtools.v84.network.model.RequestId requestId, java.util.List<org.openqa.selenium.devtools.v84.network.model.BlockedCookieWithReason> associatedCookies, org.openqa.selenium.devtools.v84.network.model.Headers headers) {
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.associatedCookies = java.util.Objects.requireNonNull(associatedCookies, "associatedCookies is required");
        this.headers = java.util.Objects.requireNonNull(headers, "headers is required");
    }

    /**
     * Request identifier. Used to match this information to an existing requestWillBeSent event.
     */
    public org.openqa.selenium.devtools.v84.network.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * A list of cookies potentially associated to the requested URL. This includes both cookies sent with
     * the request and the ones not sent; the latter are distinguished by having blockedReason field set.
     */
    public java.util.List<org.openqa.selenium.devtools.v84.network.model.BlockedCookieWithReason> getAssociatedCookies() {
        return associatedCookies;
    }

    /**
     * Raw request headers as they will be sent over the wire.
     */
    public org.openqa.selenium.devtools.v84.network.model.Headers getHeaders() {
        return headers;
    }

    private static RequestWillBeSentExtraInfo fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v84.network.model.RequestId requestId = null;
        java.util.List<org.openqa.selenium.devtools.v84.network.model.BlockedCookieWithReason> associatedCookies = null;
        org.openqa.selenium.devtools.v84.network.model.Headers headers = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v84.network.model.RequestId.class);
                    break;
                case "associatedCookies":
                    associatedCookies = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v84.network.model.BlockedCookieWithReason>>() {
                    }.getType());
                    break;
                case "headers":
                    headers = input.read(org.openqa.selenium.devtools.v84.network.model.Headers.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new RequestWillBeSentExtraInfo(requestId, associatedCookies, headers);
    }
}
