package org.openqa.selenium.devtools.v84.domsnapshot.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A Node in the DOM tree.
 */
public class DOMNode {

    private final java.lang.Integer nodeType;

    private final java.lang.String nodeName;

    private final java.lang.String nodeValue;

    private final java.util.Optional<java.lang.String> textValue;

    private final java.util.Optional<java.lang.String> inputValue;

    private final java.util.Optional<java.lang.Boolean> inputChecked;

    private final java.util.Optional<java.lang.Boolean> optionSelected;

    private final org.openqa.selenium.devtools.v84.dom.model.BackendNodeId backendNodeId;

    private final java.util.Optional<java.util.List<java.lang.Integer>> childNodeIndexes;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v84.domsnapshot.model.NameValue>> attributes;

    private final java.util.Optional<java.util.List<java.lang.Integer>> pseudoElementIndexes;

    private final java.util.Optional<java.lang.Integer> layoutNodeIndex;

    private final java.util.Optional<java.lang.String> documentURL;

    private final java.util.Optional<java.lang.String> baseURL;

    private final java.util.Optional<java.lang.String> contentLanguage;

    private final java.util.Optional<java.lang.String> documentEncoding;

    private final java.util.Optional<java.lang.String> publicId;

    private final java.util.Optional<java.lang.String> systemId;

    private final java.util.Optional<org.openqa.selenium.devtools.v84.page.model.FrameId> frameId;

    private final java.util.Optional<java.lang.Integer> contentDocumentIndex;

    private final java.util.Optional<org.openqa.selenium.devtools.v84.dom.model.PseudoType> pseudoType;

    private final java.util.Optional<org.openqa.selenium.devtools.v84.dom.model.ShadowRootType> shadowRootType;

    private final java.util.Optional<java.lang.Boolean> isClickable;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v84.domdebugger.model.EventListener>> eventListeners;

    private final java.util.Optional<java.lang.String> currentSourceURL;

    private final java.util.Optional<java.lang.String> originURL;

    private final java.util.Optional<java.lang.Number> scrollOffsetX;

    private final java.util.Optional<java.lang.Number> scrollOffsetY;

    public DOMNode(java.lang.Integer nodeType, java.lang.String nodeName, java.lang.String nodeValue, java.util.Optional<java.lang.String> textValue, java.util.Optional<java.lang.String> inputValue, java.util.Optional<java.lang.Boolean> inputChecked, java.util.Optional<java.lang.Boolean> optionSelected, org.openqa.selenium.devtools.v84.dom.model.BackendNodeId backendNodeId, java.util.Optional<java.util.List<java.lang.Integer>> childNodeIndexes, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v84.domsnapshot.model.NameValue>> attributes, java.util.Optional<java.util.List<java.lang.Integer>> pseudoElementIndexes, java.util.Optional<java.lang.Integer> layoutNodeIndex, java.util.Optional<java.lang.String> documentURL, java.util.Optional<java.lang.String> baseURL, java.util.Optional<java.lang.String> contentLanguage, java.util.Optional<java.lang.String> documentEncoding, java.util.Optional<java.lang.String> publicId, java.util.Optional<java.lang.String> systemId, java.util.Optional<org.openqa.selenium.devtools.v84.page.model.FrameId> frameId, java.util.Optional<java.lang.Integer> contentDocumentIndex, java.util.Optional<org.openqa.selenium.devtools.v84.dom.model.PseudoType> pseudoType, java.util.Optional<org.openqa.selenium.devtools.v84.dom.model.ShadowRootType> shadowRootType, java.util.Optional<java.lang.Boolean> isClickable, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v84.domdebugger.model.EventListener>> eventListeners, java.util.Optional<java.lang.String> currentSourceURL, java.util.Optional<java.lang.String> originURL, java.util.Optional<java.lang.Number> scrollOffsetX, java.util.Optional<java.lang.Number> scrollOffsetY) {
        this.nodeType = java.util.Objects.requireNonNull(nodeType, "nodeType is required");
        this.nodeName = java.util.Objects.requireNonNull(nodeName, "nodeName is required");
        this.nodeValue = java.util.Objects.requireNonNull(nodeValue, "nodeValue is required");
        this.textValue = textValue;
        this.inputValue = inputValue;
        this.inputChecked = inputChecked;
        this.optionSelected = optionSelected;
        this.backendNodeId = java.util.Objects.requireNonNull(backendNodeId, "backendNodeId is required");
        this.childNodeIndexes = childNodeIndexes;
        this.attributes = attributes;
        this.pseudoElementIndexes = pseudoElementIndexes;
        this.layoutNodeIndex = layoutNodeIndex;
        this.documentURL = documentURL;
        this.baseURL = baseURL;
        this.contentLanguage = contentLanguage;
        this.documentEncoding = documentEncoding;
        this.publicId = publicId;
        this.systemId = systemId;
        this.frameId = frameId;
        this.contentDocumentIndex = contentDocumentIndex;
        this.pseudoType = pseudoType;
        this.shadowRootType = shadowRootType;
        this.isClickable = isClickable;
        this.eventListeners = eventListeners;
        this.currentSourceURL = currentSourceURL;
        this.originURL = originURL;
        this.scrollOffsetX = scrollOffsetX;
        this.scrollOffsetY = scrollOffsetY;
    }

    /**
     * `Node`'s nodeType.
     */
    public java.lang.Integer getNodeType() {
        return nodeType;
    }

    /**
     * `Node`'s nodeName.
     */
    public java.lang.String getNodeName() {
        return nodeName;
    }

    /**
     * `Node`'s nodeValue.
     */
    public java.lang.String getNodeValue() {
        return nodeValue;
    }

    /**
     * Only set for textarea elements, contains the text value.
     */
    public java.util.Optional<java.lang.String> getTextValue() {
        return textValue;
    }

    /**
     * Only set for input elements, contains the input's associated text value.
     */
    public java.util.Optional<java.lang.String> getInputValue() {
        return inputValue;
    }

    /**
     * Only set for radio and checkbox input elements, indicates if the element has been checked
     */
    public java.util.Optional<java.lang.Boolean> getInputChecked() {
        return inputChecked;
    }

    /**
     * Only set for option elements, indicates if the element has been selected
     */
    public java.util.Optional<java.lang.Boolean> getOptionSelected() {
        return optionSelected;
    }

    /**
     * `Node`'s id, corresponds to DOM.Node.backendNodeId.
     */
    public org.openqa.selenium.devtools.v84.dom.model.BackendNodeId getBackendNodeId() {
        return backendNodeId;
    }

    /**
     * The indexes of the node's child nodes in the `domNodes` array returned by `getSnapshot`, if
     * any.
     */
    public java.util.Optional<java.util.List<java.lang.Integer>> getChildNodeIndexes() {
        return childNodeIndexes;
    }

    /**
     * Attributes of an `Element` node.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v84.domsnapshot.model.NameValue>> getAttributes() {
        return attributes;
    }

    /**
     * Indexes of pseudo elements associated with this node in the `domNodes` array returned by
     * `getSnapshot`, if any.
     */
    public java.util.Optional<java.util.List<java.lang.Integer>> getPseudoElementIndexes() {
        return pseudoElementIndexes;
    }

    /**
     * The index of the node's related layout tree node in the `layoutTreeNodes` array returned by
     * `getSnapshot`, if any.
     */
    public java.util.Optional<java.lang.Integer> getLayoutNodeIndex() {
        return layoutNodeIndex;
    }

    /**
     * Document URL that `Document` or `FrameOwner` node points to.
     */
    public java.util.Optional<java.lang.String> getDocumentURL() {
        return documentURL;
    }

    /**
     * Base URL that `Document` or `FrameOwner` node uses for URL completion.
     */
    public java.util.Optional<java.lang.String> getBaseURL() {
        return baseURL;
    }

    /**
     * Only set for documents, contains the document's content language.
     */
    public java.util.Optional<java.lang.String> getContentLanguage() {
        return contentLanguage;
    }

    /**
     * Only set for documents, contains the document's character set encoding.
     */
    public java.util.Optional<java.lang.String> getDocumentEncoding() {
        return documentEncoding;
    }

    /**
     * `DocumentType` node's publicId.
     */
    public java.util.Optional<java.lang.String> getPublicId() {
        return publicId;
    }

    /**
     * `DocumentType` node's systemId.
     */
    public java.util.Optional<java.lang.String> getSystemId() {
        return systemId;
    }

    /**
     * Frame ID for frame owner elements and also for the document node.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v84.page.model.FrameId> getFrameId() {
        return frameId;
    }

    /**
     * The index of a frame owner element's content document in the `domNodes` array returned by
     * `getSnapshot`, if any.
     */
    public java.util.Optional<java.lang.Integer> getContentDocumentIndex() {
        return contentDocumentIndex;
    }

    /**
     * Type of a pseudo element node.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v84.dom.model.PseudoType> getPseudoType() {
        return pseudoType;
    }

    /**
     * Shadow root type.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v84.dom.model.ShadowRootType> getShadowRootType() {
        return shadowRootType;
    }

    /**
     * Whether this DOM node responds to mouse clicks. This includes nodes that have had click
     * event listeners attached via JavaScript as well as anchor tags that naturally navigate when
     * clicked.
     */
    public java.util.Optional<java.lang.Boolean> getIsClickable() {
        return isClickable;
    }

    /**
     * Details of the node's event listeners, if any.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v84.domdebugger.model.EventListener>> getEventListeners() {
        return eventListeners;
    }

    /**
     * The selected url for nodes with a srcset attribute.
     */
    public java.util.Optional<java.lang.String> getCurrentSourceURL() {
        return currentSourceURL;
    }

    /**
     * The url of the script (if any) that generates this node.
     */
    public java.util.Optional<java.lang.String> getOriginURL() {
        return originURL;
    }

    /**
     * Scroll offsets, set when this node is a Document.
     */
    public java.util.Optional<java.lang.Number> getScrollOffsetX() {
        return scrollOffsetX;
    }

    public java.util.Optional<java.lang.Number> getScrollOffsetY() {
        return scrollOffsetY;
    }

    private static DOMNode fromJson(JsonInput input) {
        java.lang.Integer nodeType = 0;
        java.lang.String nodeName = null;
        java.lang.String nodeValue = null;
        java.util.Optional<java.lang.String> textValue = java.util.Optional.empty();
        java.util.Optional<java.lang.String> inputValue = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> inputChecked = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> optionSelected = java.util.Optional.empty();
        org.openqa.selenium.devtools.v84.dom.model.BackendNodeId backendNodeId = null;
        java.util.Optional<java.util.List<java.lang.Integer>> childNodeIndexes = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v84.domsnapshot.model.NameValue>> attributes = java.util.Optional.empty();
        java.util.Optional<java.util.List<java.lang.Integer>> pseudoElementIndexes = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> layoutNodeIndex = java.util.Optional.empty();
        java.util.Optional<java.lang.String> documentURL = java.util.Optional.empty();
        java.util.Optional<java.lang.String> baseURL = java.util.Optional.empty();
        java.util.Optional<java.lang.String> contentLanguage = java.util.Optional.empty();
        java.util.Optional<java.lang.String> documentEncoding = java.util.Optional.empty();
        java.util.Optional<java.lang.String> publicId = java.util.Optional.empty();
        java.util.Optional<java.lang.String> systemId = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v84.page.model.FrameId> frameId = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> contentDocumentIndex = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v84.dom.model.PseudoType> pseudoType = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v84.dom.model.ShadowRootType> shadowRootType = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> isClickable = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v84.domdebugger.model.EventListener>> eventListeners = java.util.Optional.empty();
        java.util.Optional<java.lang.String> currentSourceURL = java.util.Optional.empty();
        java.util.Optional<java.lang.String> originURL = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> scrollOffsetX = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> scrollOffsetY = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "nodeType":
                    nodeType = input.nextNumber().intValue();
                    break;
                case "nodeName":
                    nodeName = input.nextString();
                    break;
                case "nodeValue":
                    nodeValue = input.nextString();
                    break;
                case "textValue":
                    textValue = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "inputValue":
                    inputValue = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "inputChecked":
                    inputChecked = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "optionSelected":
                    optionSelected = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "backendNodeId":
                    backendNodeId = input.read(org.openqa.selenium.devtools.v84.dom.model.BackendNodeId.class);
                    break;
                case "childNodeIndexes":
                    childNodeIndexes = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<java.lang.Integer>>() {
                    }.getType()));
                    break;
                case "attributes":
                    attributes = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v84.domsnapshot.model.NameValue>>() {
                    }.getType()));
                    break;
                case "pseudoElementIndexes":
                    pseudoElementIndexes = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<java.lang.Integer>>() {
                    }.getType()));
                    break;
                case "layoutNodeIndex":
                    layoutNodeIndex = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "documentURL":
                    documentURL = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "baseURL":
                    baseURL = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "contentLanguage":
                    contentLanguage = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "documentEncoding":
                    documentEncoding = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "publicId":
                    publicId = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "systemId":
                    systemId = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "frameId":
                    frameId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v84.page.model.FrameId.class));
                    break;
                case "contentDocumentIndex":
                    contentDocumentIndex = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "pseudoType":
                    pseudoType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v84.dom.model.PseudoType.class));
                    break;
                case "shadowRootType":
                    shadowRootType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v84.dom.model.ShadowRootType.class));
                    break;
                case "isClickable":
                    isClickable = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "eventListeners":
                    eventListeners = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v84.domdebugger.model.EventListener>>() {
                    }.getType()));
                    break;
                case "currentSourceURL":
                    currentSourceURL = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "originURL":
                    originURL = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "scrollOffsetX":
                    scrollOffsetX = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "scrollOffsetY":
                    scrollOffsetY = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DOMNode(nodeType, nodeName, nodeValue, textValue, inputValue, inputChecked, optionSelected, backendNodeId, childNodeIndexes, attributes, pseudoElementIndexes, layoutNodeIndex, documentURL, baseURL, contentLanguage, documentEncoding, publicId, systemId, frameId, contentDocumentIndex, pseudoType, shadowRootType, isClickable, eventListeners, currentSourceURL, originURL, scrollOffsetX, scrollOffsetY);
    }
}
