/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.network.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public class TerminationEventDetails {
    private final DeletionReason deletionReason;

    public TerminationEventDetails(DeletionReason deletionReason) {
        this.deletionReason = Objects.requireNonNull(deletionReason, "deletionReason is required");
    }

    public DeletionReason getDeletionReason() {
        return this.deletionReason;
    }

    private static TerminationEventDetails fromJson(JsonInput input) {
        DeletionReason deletionReason = null;
        input.beginObject();
        block6: while (input.hasNext()) {
            switch (input.nextName()) {
                case "deletionReason": {
                    deletionReason = DeletionReason.fromString(input.nextString());
                    continue block6;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TerminationEventDetails(deletionReason);
    }

    public static enum DeletionReason {
        EXPIRED("Expired"),
        FAILEDTORESTOREKEY("FailedToRestoreKey"),
        FAILEDTOUNWRAPKEY("FailedToUnwrapKey"),
        STORAGEPARTITIONCLEARED("StoragePartitionCleared"),
        CLEARBROWSINGDATA("ClearBrowsingData"),
        SERVERREQUESTED("ServerRequested"),
        INVALIDSESSIONPARAMS("InvalidSessionParams"),
        REFRESHFATALERROR("RefreshFatalError");

        private String value;

        private DeletionReason(String value) {
            this.value = value;
        }

        public static DeletionReason fromString(String s) {
            return Arrays.stream(DeletionReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within DeletionReason "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DeletionReason fromJson(JsonInput input) {
            return DeletionReason.fromString(input.nextString());
        }
    }
}

