/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.network.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v145.network.model.DeviceBoundSession;
import org.openqa.selenium.devtools.v145.network.model.DeviceBoundSessionFetchResult;
import org.openqa.selenium.json.JsonInput;

@Beta
public class RefreshEventDetails {
    private final RefreshResult refreshResult;
    private final Optional<DeviceBoundSessionFetchResult> fetchResult;
    private final Optional<DeviceBoundSession> newSession;
    private final Boolean wasFullyProactiveRefresh;

    public RefreshEventDetails(RefreshResult refreshResult, Optional<DeviceBoundSessionFetchResult> fetchResult, Optional<DeviceBoundSession> newSession, Boolean wasFullyProactiveRefresh) {
        this.refreshResult = Objects.requireNonNull(refreshResult, "refreshResult is required");
        this.fetchResult = fetchResult;
        this.newSession = newSession;
        this.wasFullyProactiveRefresh = Objects.requireNonNull(wasFullyProactiveRefresh, "wasFullyProactiveRefresh is required");
    }

    public RefreshResult getRefreshResult() {
        return this.refreshResult;
    }

    public Optional<DeviceBoundSessionFetchResult> getFetchResult() {
        return this.fetchResult;
    }

    public Optional<DeviceBoundSession> getNewSession() {
        return this.newSession;
    }

    public Boolean getWasFullyProactiveRefresh() {
        return this.wasFullyProactiveRefresh;
    }

    private static RefreshEventDetails fromJson(JsonInput input) {
        RefreshResult refreshResult = null;
        Optional<DeviceBoundSessionFetchResult> fetchResult = Optional.empty();
        Optional<DeviceBoundSession> newSession = Optional.empty();
        Boolean wasFullyProactiveRefresh = false;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "refreshResult": {
                    refreshResult = RefreshResult.fromString(input.nextString());
                    continue block12;
                }
                case "fetchResult": {
                    fetchResult = Optional.ofNullable((DeviceBoundSessionFetchResult)((Object)input.read(DeviceBoundSessionFetchResult.class)));
                    continue block12;
                }
                case "newSession": {
                    newSession = Optional.ofNullable((DeviceBoundSession)input.read(DeviceBoundSession.class));
                    continue block12;
                }
                case "wasFullyProactiveRefresh": {
                    wasFullyProactiveRefresh = input.nextBoolean();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RefreshEventDetails(refreshResult, fetchResult, newSession, wasFullyProactiveRefresh);
    }

    public static enum RefreshResult {
        REFRESHED("Refreshed"),
        INITIALIZEDSERVICE("InitializedService"),
        UNREACHABLE("Unreachable"),
        SERVERERROR("ServerError"),
        REFRESHQUOTAEXCEEDED("RefreshQuotaExceeded"),
        FATALERROR("FatalError"),
        SIGNINGQUOTAEXCEEDED("SigningQuotaExceeded");

        private String value;

        private RefreshResult(String value) {
            this.value = value;
        }

        public static RefreshResult fromString(String s) {
            return Arrays.stream(RefreshResult.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within RefreshResult "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static RefreshResult fromJson(JsonInput input) {
            return RefreshResult.fromString(input.nextString());
        }
    }
}

