/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.network.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DeviceBoundSessionUrlRule {
    private final RuleType ruleType;
    private final String hostPattern;
    private final String pathPrefix;

    public DeviceBoundSessionUrlRule(RuleType ruleType, String hostPattern, String pathPrefix) {
        this.ruleType = Objects.requireNonNull(ruleType, "ruleType is required");
        this.hostPattern = Objects.requireNonNull(hostPattern, "hostPattern is required");
        this.pathPrefix = Objects.requireNonNull(pathPrefix, "pathPrefix is required");
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public String getHostPattern() {
        return this.hostPattern;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    private static DeviceBoundSessionUrlRule fromJson(JsonInput input) {
        RuleType ruleType = null;
        String hostPattern = null;
        String pathPrefix = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "ruleType": {
                    ruleType = RuleType.fromString(input.nextString());
                    continue block10;
                }
                case "hostPattern": {
                    hostPattern = input.nextString();
                    continue block10;
                }
                case "pathPrefix": {
                    pathPrefix = input.nextString();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DeviceBoundSessionUrlRule(ruleType, hostPattern, pathPrefix);
    }

    public static enum RuleType {
        EXCLUDE("Exclude"),
        INCLUDE("Include");

        private String value;

        private RuleType(String value) {
            this.value = value;
        }

        public static RuleType fromString(String s) {
            return Arrays.stream(RuleType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within RuleType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static RuleType fromJson(JsonInput input) {
            return RuleType.fromString(input.nextString());
        }
    }
}

