/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v145.network.model.DeviceBoundSession;
import org.openqa.selenium.devtools.v145.network.model.DeviceBoundSessionFetchResult;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CreationEventDetails {
    private final DeviceBoundSessionFetchResult fetchResult;
    private final Optional<DeviceBoundSession> newSession;

    public CreationEventDetails(DeviceBoundSessionFetchResult fetchResult, Optional<DeviceBoundSession> newSession) {
        this.fetchResult = Objects.requireNonNull(fetchResult, "fetchResult is required");
        this.newSession = newSession;
    }

    public DeviceBoundSessionFetchResult getFetchResult() {
        return this.fetchResult;
    }

    public Optional<DeviceBoundSession> getNewSession() {
        return this.newSession;
    }

    private static CreationEventDetails fromJson(JsonInput input) {
        DeviceBoundSessionFetchResult fetchResult = null;
        Optional<DeviceBoundSession> newSession = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "fetchResult": {
                    fetchResult = (DeviceBoundSessionFetchResult)((Object)input.read(DeviceBoundSessionFetchResult.class));
                    continue block8;
                }
                case "newSession": {
                    newSession = Optional.ofNullable((DeviceBoundSession)input.read(DeviceBoundSession.class));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CreationEventDetails(fetchResult, newSession);
    }
}

