/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.network.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ChallengeEventDetails {
    private final ChallengeResult challengeResult;
    private final String challenge;

    public ChallengeEventDetails(ChallengeResult challengeResult, String challenge) {
        this.challengeResult = Objects.requireNonNull(challengeResult, "challengeResult is required");
        this.challenge = Objects.requireNonNull(challenge, "challenge is required");
    }

    public ChallengeResult getChallengeResult() {
        return this.challengeResult;
    }

    public String getChallenge() {
        return this.challenge;
    }

    private static ChallengeEventDetails fromJson(JsonInput input) {
        ChallengeResult challengeResult = null;
        String challenge = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "challengeResult": {
                    challengeResult = ChallengeResult.fromString(input.nextString());
                    continue block8;
                }
                case "challenge": {
                    challenge = input.nextString();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ChallengeEventDetails(challengeResult, challenge);
    }

    public static enum ChallengeResult {
        SUCCESS("Success"),
        NOSESSIONID("NoSessionId"),
        NOSESSIONMATCH("NoSessionMatch"),
        CANTSETBOUNDCOOKIE("CantSetBoundCookie");

        private String value;

        private ChallengeResult(String value) {
            this.value = value;
        }

        public static ChallengeResult fromString(String s) {
            return Arrays.stream(ChallengeResult.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ChallengeResult "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static ChallengeResult fromJson(JsonInput input) {
            return ChallengeResult.fromString(input.nextString());
        }
    }
}

