/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v144.network.model.SignedExchangeErrorField;
import org.openqa.selenium.json.JsonInput;

@Beta
public class SignedExchangeError {
    private final String message;
    private final Optional<Integer> signatureIndex;
    private final Optional<SignedExchangeErrorField> errorField;

    public SignedExchangeError(String message, Optional<Integer> signatureIndex, Optional<SignedExchangeErrorField> errorField) {
        this.message = Objects.requireNonNull(message, "message is required");
        this.signatureIndex = signatureIndex;
        this.errorField = errorField;
    }

    public String getMessage() {
        return this.message;
    }

    public Optional<Integer> getSignatureIndex() {
        return this.signatureIndex;
    }

    public Optional<SignedExchangeErrorField> getErrorField() {
        return this.errorField;
    }

    private static SignedExchangeError fromJson(JsonInput input) {
        String message = null;
        Optional<Integer> signatureIndex = Optional.empty();
        Optional<SignedExchangeErrorField> errorField = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "message": {
                    message = input.nextString();
                    continue block10;
                }
                case "signatureIndex": {
                    signatureIndex = Optional.ofNullable(input.nextNumber().intValue());
                    continue block10;
                }
                case "errorField": {
                    errorField = Optional.ofNullable((SignedExchangeErrorField)((Object)input.read(SignedExchangeErrorField.class)));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SignedExchangeError(message, signatureIndex, errorField);
    }
}

