/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v143.systeminfo.model;

import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v143.systeminfo.model.ImageType;
import org.openqa.selenium.devtools.v143.systeminfo.model.Size;
import org.openqa.selenium.devtools.v143.systeminfo.model.SubsamplingFormat;
import org.openqa.selenium.json.JsonInput;

public class ImageDecodeAcceleratorCapability {
    private final ImageType imageType;
    private final Size maxDimensions;
    private final Size minDimensions;
    private final List<SubsamplingFormat> subsamplings;

    public ImageDecodeAcceleratorCapability(ImageType imageType, Size maxDimensions, Size minDimensions, List<SubsamplingFormat> subsamplings) {
        this.imageType = Objects.requireNonNull(imageType, "imageType is required");
        this.maxDimensions = Objects.requireNonNull(maxDimensions, "maxDimensions is required");
        this.minDimensions = Objects.requireNonNull(minDimensions, "minDimensions is required");
        this.subsamplings = Objects.requireNonNull(subsamplings, "subsamplings is required");
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public Size getMaxDimensions() {
        return this.maxDimensions;
    }

    public Size getMinDimensions() {
        return this.minDimensions;
    }

    public List<SubsamplingFormat> getSubsamplings() {
        return this.subsamplings;
    }

    private static ImageDecodeAcceleratorCapability fromJson(JsonInput input) {
        ImageType imageType = null;
        Size maxDimensions = null;
        Size minDimensions = null;
        List subsamplings = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "imageType": {
                    imageType = (ImageType)((Object)input.read(ImageType.class));
                    continue block12;
                }
                case "maxDimensions": {
                    maxDimensions = (Size)input.read(Size.class);
                    continue block12;
                }
                case "minDimensions": {
                    minDimensions = (Size)input.read(Size.class);
                    continue block12;
                }
                case "subsamplings": {
                    subsamplings = input.readArray(SubsamplingFormat.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ImageDecodeAcceleratorCapability(imageType, maxDimensions, minDimensions, subsamplings);
    }
}

